/************************************************************************
* FILE:           tun_HMIManager.h
* PROJECT:       g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages sent to HMI are handled in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 11.03.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_HMIMANAGER_H
#define TUN_HMIMANAGER_H

#define  FID_TUN_NOT_DEFINED    0x00    //added to reset the FID to some unused value i.e.00

#define  BG_TUN_BAND_SEL        0xff

// Maximum number of static list elements are 10.
#define TUN_STATIC_LIST_NUM_OF_ELEMENTS 10

/*----------------------------------*/
/* class tun_HMIManager definition  */
/*----------------------------------*/

#include "../Header/tun_Msg_types.h"
#include "tun_MsgDefines.h"
#include "tun_Class_ForwardDecl.h"

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif




//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
//
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

// Manual tune status
#define TUN_MAN_TUNE_STATUS_INPROGRESS      0x01
#define TUN_MAN_TUNE_STATUS_COMPLETE        0x02
#define TUN_MAN_TUNE_BUSY 0x03
#define TUN_MAN_TUNE_READY 0x04
#define TUN_MAN_TUNE_STATUS_NOT_ACTIVE      0xff
//-----------------------------------------------

/*Forward declaration*/
class clConfigInterface;

class tun_HMIManager
{


 /*This flag is used to decide whether the Landscape is running or not.
 	if bCheckLandscapeFlag = TRUE means Landscape started
	if bCheckGetDataFrq = FALSE means Landscape not yet started*/
 tBool bCheckLandscapeFlag;

public:
   tun_HMIManager( tuner_tclApp* poMain );

  tun_HMIManager( );

  ~tun_HMIManager( );


  /*----------------*/
  /* Tuner Manager  */
  /*----------------*/   
  tu_Manager* m_potu_Manager;

  /*------------------------------------*/
  /* Tuner Data is sored in this class  */
  /*------------------------------------*/
  tun_ActualData* m_potun_ActualData;

  tun_Utility* m_potun_Utility;

  tun_Config* m_potun_Config;

  tuner_tclApp*    poGWMain;

  clConfigInterface* 	m_poclConfigInterface;

  /*---------------------------*/
  /* class sends message to RU */
  /*---------------------------*/
  tun_MsgToADR* m_potun_MsgToADR;

  tVoid vSet_tu_Manager_Ptr( tu_Manager* potu_Manager );

  tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

  tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility );

  tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );

  tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR );

  tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

  tVoid vConvertRDSPSNametotString(const tU8 * aPSName, midw_fi_tclString *sUTF8String)const;

  tVoid vConvertRTextTotString( const tU8 *apRText, midw_fi_tclString *sUTF8String, tU8 u8Len)const;

  tVoid vSetLandscapeFlag( tBool bTunerCheckLandscapeFlag );
  tBool bGetLandscapeFlag()const;

};

#endif /* TUN_HMIMANAGER_H */
