/************************************************************************
* FILE:           tun_defines.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All headers specific to Tuner component.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
*  25.04.13  | NGP1KOR    | First version of the G3g after porting 
								from NISSAN LCN2Kai
*************************************************************************/

/** 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai*/
#ifndef _TUN_FI_HELPFUNC_H_
#define _TUN_FI_HELPFUNC_H_

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK

#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif




#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
class tuner_tclApp;

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
//
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"



class tun_FI_HelpFunc
{   
  
  tuner_tclApp*                poGWMain;

public:



/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumListIDType(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumListIDType(tU8 u8StaticListID ,midw_fi_tcl_e8_Tun_StaticListID::
                                    tenType &enStaticListID
                                        )
  {
//    tBool flag =true;
    switch(u8StaticListID)
    {
    case 0:
      { 
        enStaticListID =midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_FM1;
        break;
      }
      
    case 1:
      { 
        enStaticListID = midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_FM2;
        break;
      }
      
    case 2:
      { 
        enStaticListID = midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_FM3;
        break;
      }
      
    case 3:
      { 
        enStaticListID = midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_AST;
        break;
      }
      
    case 4:
      { 
        enStaticListID = midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_AM1;
        break;
      }
      
    case 5:
      { 
        enStaticListID = midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_LW1;
        break;
      }
      
    default:
      {   
//        flag =false;
        break;
      }
      
    };
//    return flag;
    
  }


/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumListIDType(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConvertEnumListIDTypetotU8(midw_fi_tcl_e8_Tun_TunerStaticList ::
                                    tenType enStaticListID,tU8 &u8StaticListID )
  {

	  switch((midw_fi_tcl_e8_Tun_StaticListID::tenType)enStaticListID)
    {
    case midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_FM1:
      { u8StaticListID=0;
        
        break;
      }
      
    case midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_FM2:
      { 
         u8StaticListID=1;
        break;
      }
      
    case midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_FM3:
      { 
        u8StaticListID=2;
        break;
      }
      
    case  midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_AST:
      { 
        u8StaticListID=3;
        break;
      }
      
    case midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_AM1:
      { 
        u8StaticListID=4;
        break;
      }
      
    case midw_fi_tcl_e8_Tun_StaticListID::FI_EN_TUN_TUN_STATIC_LIST_LW1:
      { 
        u8StaticListID=5;
        break;
      }
      
    default:
      {   

        break;
      }
      
    };
//    return flag;
    
  }

/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumListIDType(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumHeader(tU8 u8Tun_Header, midw_fi_tcl_e8_Tun_TunerHeader ::tenType &u8TunerHeader )
  {

    switch(u8Tun_Header)
    {
    case 0:
      {
       u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    case 1:
      { 
        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_BACKGROUND;
        break;
      }
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
}


static tVoid /*tBool*/ bConverttU8toEnumPhsicalTuner(tU8 u8Tun_Header, midw_fi_tcl_e8_Tun_PhysicalTuner ::tenType &u8PhysicalTuner )
  {

    switch(u8Tun_Header)
    {
    case 1:
      {
       u8PhysicalTuner = midw_fi_tcl_e8_Tun_PhysicalTuner ::FI_EN_TUNER_0;
        break;
      }
      
    case 2:
      { 
        u8PhysicalTuner = midw_fi_tcl_e8_Tun_PhysicalTuner ::FI_EN_TUNER_1;
        break;
      }
	  
	  case 3:
      { 
        u8PhysicalTuner = midw_fi_tcl_e8_Tun_PhysicalTuner ::FI_EN_TUNER_2;
        break;
      }
	  
	  case 4:
      { 
        u8PhysicalTuner = midw_fi_tcl_e8_Tun_PhysicalTuner ::FI_EN_TUNER_3;
        break;
      }
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
}


/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumListIDType(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumAddnlInfo(tU8 u8AddnlInfo, midw_fi_tcl_e8_Tun_AdditionalInfo :: tenType &u8TunAdditionalInfo )
  {

    switch(u8AddnlInfo)
    {
    case 1:
      {
        u8TunAdditionalInfo = midw_fi_tcl_e8_Tun_AdditionalInfo ::FI_EN_TUN_RDS_SYNC;
        
        break;
      }
      
    case 2:
      { 
         u8TunAdditionalInfo = midw_fi_tcl_e8_Tun_AdditionalInfo ::FI_EN_TUN_AF_CHANGE_REQUEST;
        break;
      }
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
//    return flag;

}

//
///*************************************************************************
//*
//* FUNCTION:     bConverttU8toEnumListIDType(  )
//* 
//* DESCRIPTION:  Get current selected config list by the user.
//*
//* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
//*
//* RETURNVALUE:   tVoid 
//*
//*************************************************************************/
//static tVoid /*tBool*/ bConverttU8toEnumTestModeBits(tU8 u8TestModeBit, midw_fi_tcl_e8_Tun_TestmodeBits :: tenType &u8TestModeBits)
//  {
//
//    switch(u8TestModeBit)
//    {
//    case 1:
//      {
//        u8TestModeBits = midw_fi_tcl_e8_Tun_TestmodeBits ::FI_EN_TUN_TP_BIT;
//        
//        break;
//      }
//      
//    case 2:
//      { 
//         u8TestModeBits = midw_fi_tcl_e8_Tun_TestmodeBits ::FI_EN_TUN_TA_BIT;
//        break;
//      }
//      
//    default:
//      {   
////        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
//        break;
//      }
//      
//    };
////    return flag;
//
//}


/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumIFState(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumIFState(tU8 u8IFStateByte, midw_fi_tcl_e8_Tun_IfState :: tenType &u8IFState)
  {

    switch(u8IFStateByte)
    {
    case 0:
      {
        u8IFState = midw_fi_tcl_e8_Tun_IfState ::FI_EN_TUN_OFF;
        
        break;
      }

    case 1:
      {
        u8IFState = midw_fi_tcl_e8_Tun_IfState ::FI_EN_TUN_ON;
        
        break;
      }
            
    case 2:
      { 
         u8IFState = midw_fi_tcl_e8_Tun_IfState ::FI_EN_TUN_UNKNOWN;
        break;
      }
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
//    return flag;
  }


/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumTMCGroupSt(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumTMCGroupSt(tU8 u8TMCGroupSt, midw_fi_tcl_e8_Tun_TMCGroupState :: tenType &u8TMCGroupState)
  {

    switch(u8TMCGroupSt)
    {
    case 0:
      {
        u8TMCGroupState = midw_fi_tcl_e8_Tun_TMCGroupState ::FI_EN_TUN_NO_DATA_AVAILABLE;
        
        break;
      }

    case 1:
      {
        u8TMCGroupState = midw_fi_tcl_e8_Tun_TMCGroupState ::FI_EN_TUN_DATA_NOT_REPEATED;
        
        break;
      }
      
    case 2:
      { 
         u8TMCGroupState = midw_fi_tcl_e8_Tun_TMCGroupState ::FI_EN_TUN_TWO_GROUPS_IDENTICAL;
        break;
      }
      
    case 3:
      {
        u8TMCGroupState = midw_fi_tcl_e8_Tun_TMCGroupState ::FI_EN_TUN_THREE_GROUPS_IDENTICAL;
        
        break;
      }

    case 64:
      {
        u8TMCGroupState = midw_fi_tcl_e8_Tun_TMCGroupState ::FI_EN_TUN_GROUP_3A_DETECTED;
        
        break;
      }
            
    case 128:
      { 
         u8TMCGroupState = midw_fi_tcl_e8_Tun_TMCGroupState ::FI_EN_TUN_AFI_BIT;
        break;
      }

      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
//    return flag;

}


/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumAntennaSt(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumAntennaSt(tU8 u8AntennaStateByte, midw_fi_tcl_e8_Tun_AntennaState :: tenType &u8AntennaState)
  {

    switch(u8AntennaStateByte)
    {
    case 0:
      {
        u8AntennaState = midw_fi_tcl_e8_Tun_AntennaState ::FI_EN_TUN_PHANTOM_SUPPLY_OFF;
        
        break;
      }

    case 1:
      {
        u8AntennaState = midw_fi_tcl_e8_Tun_AntennaState ::FI_EN_TUN_PHANTOM_SUPPLY_ON;
        
        break;
      }
            
    case 2:
      { 
         u8AntennaState = midw_fi_tcl_e8_Tun_AntennaState ::FI_EN_TUN_PHANTOM_SUPPLY_UNKNOWN;
        break;
      }
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
//    return flag;
  }

/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumMode(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
static tVoid /*tBool*/ bConverttU8toEnumMode(tU8 u8ModeByte, midw_fi_tcl_e8_Tuner_Mode :: tenType &u8Mode)
  {

    switch(u8ModeByte)
    {
    case 0:
      {
        u8Mode = midw_fi_tcl_e8_Tuner_Mode ::FI_EN_TUN_CAL;
        
        break;
      }

    case 4:
      {
        u8Mode = midw_fi_tcl_e8_Tuner_Mode ::FI_EN_TUN_DDA;
        
        break;
      }
            
    case 8:
      { 
         u8Mode = midw_fi_tcl_e8_Tuner_Mode ::FI_EN_TUN_DDS;
        break;
      }
	case 10:
      { 
         u8Mode = midw_fi_tcl_e8_Tuner_Mode ::FI_EN_TUN_SINGLE;
        break;
      }
	 
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    };
//    return flag;
  }


};



#endif//



