/************************************************************************
* FILE:           HelpFunc.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All headers specific to Tuner component.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 5.8.06    | RBIN/EDI1 Pushpa             | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef _HELP_FUNCTIONS
#define _HELP_FUNCTIONS

#include "tun_Diag_defines.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_TYPES

class tun_diagHelpFn
{
public:


/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertFIMonitor                                 */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_MonitoringMode : enum type                     */
/*               tU8& :User defined type                                           */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
static tBool bConvertFIMonitor(midw_fi_tcl_e8_Tun_MonitoringMode::
                                              tenType enMonitoringMode,
                                                    tU8& u8MonitorMode )
{
  bool flag = true;

  switch(enMonitoringMode)
  {
  case midw_fi_tcl_e8_Tun_MonitoringMode :: FI_EN_FC_TUNER_MONITORING_OFF:
    {
      u8MonitorMode = (tU8)TUNER_MONITORING_OFF;

      break;
    }
  
  case midw_fi_tcl_e8_Tun_MonitoringMode :: FI_EN_FC_TUNER_MONITORING_CONTINUOUS:
    {
      u8MonitorMode = (tU8)TUNER_MONITORING_CONTINUOUS;

      break;
    }
  
  case midw_fi_tcl_e8_Tun_MonitoringMode :: FI_EN_FC_TUNER_MONITORING_SINGLE :
  case midw_fi_tcl_e8_Tun_MonitoringMode :: FI_EN_FC_TUNER_MONITORING_DEFAULTMODE:
    {
      u8MonitorMode = (tU8)TUNER_MONITORING_SINGLE;
         
      break;
    }
  
  case midw_fi_tcl_e8_Tun_MonitoringMode :: FI_EN_FC_TUNER_MONITORING_PREVIOUSMODE:
    {
      u8MonitorMode = (tU8)TUNER_MONITORING_PREVIOUSMODE;

      break;
    }
  
  default:
    {
      u8MonitorMode = (tU8)TUNER_MONITORING_OFF;
      
         flag = false;
      break;
    }
  }
      return flag;

}

/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertFISupervision                             */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_SupervisionControl : enum type                 */
/*               tU8& :User defined type                                           */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
static tBool bConvertFISupervision(midw_fi_tcl_e8_Tun_SupervisionControl::
                                        tenType enSupervisionControl, 
                                            tU8& u8SupervisionControl )
{
  bool flag = true;

  switch(enSupervisionControl)
  {
  case midw_fi_tcl_e8_Tun_SupervisionControl::FI_EN_FC_TUNER_SUPERVISION_DEFAULT:
    {
      u8SupervisionControl = (tU8)TUNER_SUPERVISION_DEFAULT;
      break;
    }
  
  case midw_fi_tcl_e8_Tun_SupervisionControl::FI_EN_FC_TUNER_SUPERVISION_ON:
    {
      u8SupervisionControl = (tU8)TUNER_SUPERVISION_ON;

      break;
    }
  
  case midw_fi_tcl_e8_Tun_SupervisionControl::FI_EN_FC_TUNER_SUPERVISION_OFF :
    {
      u8SupervisionControl = (tU8)TUNER_SUPERVISION_OFF;

      break;
    }
  
  default:
    {
      u8SupervisionControl = (tU8)TUNER_SUPERVISION_OFF;
         flag = false;
      break;
    }
  }
      return flag;
}


/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertErrorStToFI                               */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_ErrorStatus : enum type                        */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
static tBool bConvertErrorStToFI(tU8 u8ErrorStatus, midw_fi_tcl_e8_Tun_ErrorStatus::
                                                      tenType &enErrorStatus )
{ bool flag = true;

  switch(u8ErrorStatus)
  {
  case TUNER_TEST_PASSED:
    {
      enErrorStatus = midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_PASSED;
      break;
    }
  
  case TUNER_TEST_FAILED:
    {
      enErrorStatus = midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_FAILED;

      break;
    }
  
  case TUNER_TEST_NEVER_RAN:
    {
      enErrorStatus = midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_NEVER_RAN ;

      break;
    }
  
  default:
    {
      enErrorStatus = midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_NEVER_RAN;
         flag = false;

      break;
    }
  }

  return flag;
}


/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertRoutineStToFI                             */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
static tBool bConvertRoutineStToFI( tU8 u8RoutineStatus,  
                                      midw_fi_tcl_e8_Tun_RoutineStatus::tenType 
                                            &enRoutineStatus  )
{

  bool flag = true;

  switch(u8RoutineStatus)
  {
  case TUNER_ROUTINE_NOT_RUNNING:
    {
      enRoutineStatus = midw_fi_tcl_e8_Tun_RoutineStatus::FI_EN_FC_TUNER_ROUTINE_NOT_RUNNING;

      break;
    }
  
  case TUNER_ROUTINE_RUNNING:
    {
      enRoutineStatus = midw_fi_tcl_e8_Tun_RoutineStatus::FI_EN_FC_TUNER_ROUTINE_RUNNING;

      break;
    }
  
  case TUNER_ROUTINE_FINISHED:
    {
      enRoutineStatus = midw_fi_tcl_e8_Tun_RoutineStatus::FI_EN_FC_TUNER_ROUTINE_FINISHED ;

      break;
    }
  case TUNER_ROUTINE_CANCELLED:
    {
      enRoutineStatus = midw_fi_tcl_e8_Tun_RoutineStatus::FI_EN_FC_TUNER_ROUTINE_CANCELLED ;

      break;
    }
  
  
  default:
    {
      enRoutineStatus = midw_fi_tcl_e8_Tun_RoutineStatus::FI_EN_FC_TUNER_ROUTINE_NOT_RUNNING;
         flag = false;

      break;
    }
  }

  return flag;

}


/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertResultStToFI                              */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
static tBool bConvertResultStToFI( tU8 u8ResultSt, midw_fi_tcl_e8_TestResult::
                                                         tenType &enResultStatus  )
{

  bool flag = true;

  switch(u8ResultSt)
  {
  case TUN_TEST_PASSED:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;

      break;
    }
  
  case TUN_TEST_FAILED:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;

      break;
    }
  
  case TUN_TEST_NO_RESULT:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_NORESULT ;

      break;
    }
  
  case TUN_TEST_PASSEDDIAG:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_PASSEDDIAGNOSTIC;

      break;
    }
  
  case TUN_TEST_FAILEDDIAG:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_FAILEDDIAGNOSTIC;

      break;
    }
  
  case TUN_TEST_NO_RESULTDIAG:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_NORESULTDIAGNOSTIC ;

      break;
    }
  
  default:
    {
      enResultStatus = midw_fi_tcl_e8_TestResult::FI_EN_NORESULT;

      flag = false;

      break;
    }
  }

  return flag;
}

/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertResultStToFI                              */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
static tVoid vValuateResultStatus (midw_fi_tcl_e8_Tun_ErrorStatus::
                                                  tenType enResultStatus, tU8 &u8Result)
{
  switch(enResultStatus)
  {
  case midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_PASSED:
    {
      u8Result = (tU8)TUN_TEST_PASSEDDIAG;
      break;
    }

  case midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_FAILED:
    {
      u8Result = (tU8)TUN_TEST_FAILEDDIAG;
      break;
    }

  case midw_fi_tcl_e8_Tun_ErrorStatus::FI_EN_FC_TUNER_TEST_NEVER_RAN:
    {
      u8Result = (tU8)TUN_TEST_NO_RESULTDIAG;
      break;
    }

    
  default:
    {
      u8Result = (tU8)TUN_TEST_NO_RESULTDIAG;
      break;
    }

  }

}

/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertResultStToFI                              */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
/*static tBool bConvertTunAlignCalibratetotU8 (midw_fi_tcl_e8_Tun_AlignCalibrate::
                                        tenType enAlignCalibrate, tU8 &u8AlignCal)
{ tBool bFlag = true;

    switch(enAlignCalibrate)
    {
    case midw_fi_tcl_e8_Tun_AlignCalibrate::FI_EN_TUN_INVALID_STEP:
      {
        u8AlignCal = 0;
        break;
      }
  
    case midw_fi_tcl_e8_Tun_AlignCalibrate::FI_EN_TUNER_STEP_ONE_ALIGNMENT:
      {
        u8AlignCal = 1;
        break;
      }
    case midw_fi_tcl_e8_Tun_AlignCalibrate::FI_EN_TUNER_STEP_TWO_ALIGNMENT:
      {
        u8AlignCal = 2;
        break;
      }
    case midw_fi_tcl_e8_Tun_AlignCalibrate::FI_EN_TUNER_ONE_FM_CALIBRATION:
      {
        u8AlignCal = 3;
        break;
      }
  
    case midw_fi_tcl_e8_Tun_AlignCalibrate::FI_EN_TUNER_TWO_FM_CALIBRATION:
      {
        u8AlignCal = 4;
        break;
      }
  
    case midw_fi_tcl_e8_Tun_AlignCalibrate::FI_EN_TUNER_ONE_AM_CALIBRATION:
      {
        u8AlignCal = 5;
        break;
      }
  
    default:
      {
        bFlag =false;
        u8AlignCal = 0;
        break;
      }
  
    }
    return bFlag;

}*/
/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConverttU8toTunAlignCalibrate                    */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
/*static tBool bConverttU8toTunAlignCalibrate (tU8 u8TunAlignCalStatus, midw_fi_tcl_e8_Tun_AlignCalibrateStatus::
                                        tenType &enTunAlignCalStatus)
{
	//OS_TRACE(1);(1);
	
	tBool bFlag = true;

    switch(u8TunAlignCalStatus)
    {
    case 0:
      {
		  //OS_TRACE(1);(1);
        enTunAlignCalStatus = midw_fi_tcl_e8_Tun_AlignCalibrateStatus::FI_EN_TUN_ALIGN_CALIBRATE_NOT_SUCCESS;
        
        break;
      }
  
    case 1:
      {
		  //OS_TRACE(1);(1);
        enTunAlignCalStatus = midw_fi_tcl_e8_Tun_AlignCalibrateStatus::FI_EN_TUN_ALIGN_CALIBRATE_SUCCESS;
        break;
      }
 
    default:
      {
		  //OS_TRACE(1);(1);
        bFlag =false;
        enTunAlignCalStatus = midw_fi_tcl_e8_Tun_AlignCalibrateStatus::FI_EN_TUN_ALIGN_CALIBRATE_NOT_SUCCESS;
        break;
      }
  
    }
    return bFlag;

}*/

/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertTunerBandtotU8                    */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
/*static tBool bConvertTunerBandtotU8 ( midw_fi_tcl_e8_Tun_TunerBand::
                                        tenType enTunerBand,tU8 &u8TunedBand)
{
	//OS_TRACE(1);(1);
	
	tBool bFlag = true;

    switch(u8TunedBand)
    {
    case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 0;
        
        break;
      }
  
    case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 1;
        break;
      }

	case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_LW:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 2;
        break;
      }

	  case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_SW:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 3;
        break;
      }

	  case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_DCF77:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 4;
        break;
      }

	  case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_TRAFFICBAND:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 5;
        break;
      }

	  case midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_WEATHERBAND:
      {
		  //OS_TRACE(1);(1);
        u8TunedBand = 6;
        break;
      }
    default:
      {
		  //OS_TRACE(1);(1);
        bFlag =false;
        u8TunedBand = 0;
        break;
      }
  
    }
    return bFlag;

}
*/

/***********************************************************************************/
/*                                                                                 */
/* FUNCTION:     tun_diagHelpFn::bConvertTunerTypetotU8                  */
/*                                                                                 */
/* DESCRIPTION:  This Function converts the FI type to the user defined            */
/*               type and validates incoming value                                 */
/*                                                                                 */
/* PARAMETER:    midw_fi_tcl_e8_Tun_RoutineStatus : enum type                      */
/*               tU8 :User defined type                                            */
/*                                                                                 */
/* RETURNVALUE:  tbool                                                             */
/*                                                                                 */
/***********************************************************************************/
/*static tBool bConvertTunerTypetotU8( midw_fi_tcl_e8_Tun_SubCommand::
                                        tenType enTunerSubCommand,tU8 &u8SubCommand)
{
	//OS_TRACE(1);(1);
	
	tBool bFlag = true;

    switch(u8SubCommand)
    {
    case midw_fi_tcl_e8_Tun_SubCommand::FI_EN_TUN_CHANGE_TO_FG:
      {
		  //OS_TRACE(1);(1);
        u8SubCommand = 0;
        
        break;
      }
  
    case midw_fi_tcl_e8_Tun_SubCommand::FI_EN_TUN_CHANGE_TO_BG:
      {
		  //OS_TRACE(1);(1);
        u8SubCommand = 1;
        break;
      }
 
    default:
      {
		  //OS_TRACE(1);(1);
        bFlag =false;
        u8SubCommand = 0;
        break;
      }
  
    }
    return bFlag;

}*/

/*************************************************************************
*
* FUNCTION:     bConverttU8toEnumIFResult(  )
* 
* DESCRIPTION:  Get current selected config list by the user.
*
* PARAMETER:    tU8 u8StaticListID, midw_fi_tcl_e8_Tun_StaticListID:: tenType &enStaticListID
*
* RETURNVALUE:   tVoid 
*
*************************************************************************/
/*static tVoid  bConverttU8toEnumIFResult(tU8 u8IFResult, midw_fi_tcl_e8_Tun_IFOutput:: tenType &enu8IFResult)
  {

    switch(u8IFResult)
    {
    case 01:
      {
        u8IFResult = midw_fi_tcl_e8_Tun_IFOutput ::FI_EN_TUN_IF_OUTPUT_OK;
        
        break;
      }

    case 10:
      {
        u8IFResult = midw_fi_tcl_e8_Tun_IFOutput::FI_EN_TUN_IF_OUTPUT_ERR_SHORT;
        
        break;
      }
            
    case 11:
      { 
         u8IFResult = midw_fi_tcl_e8_Tun_IFOutput ::FI_EN_TUN_IF_OUTPUT_ERR_DISCON_IMP;
        break;
      }
	case 20:
      { 
         u8IFResult = midw_fi_tcl_e8_Tun_IFOutput ::FI_EN_TUN_IF_OUTPUT_UNKNOWN;
        break;
      }
	 case 00:
      { 
         u8IFResult = midw_fi_tcl_e8_Tun_IFOutput ::FI_EN_TUN_IF_OUTPUT_ERR_DISCON_ANT;
        break;
      }
      
    default:
      {   
//        u8TunerHeader = midw_fi_tcl_e8_Tun_TunerHeader ::FI_EN_TUN_FOREGROUND;
        break;
      }
      
    }
//    return flag;
  

	}

*/
};

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
/******************************************************************************
*FUNCTION:      u32GetBits
*DESCRIPTION:   This function returns the (right adjusted) n-bit (u16Num_bits) 
*               field of Number (u32Num_shift) that begins at position p 
*               (u16Pos)
*PARAMETER:     tU32 u32Num_shift, tU16 u16Pos, tU16 u16Num_bits  
*           
*RETURNVALUE:   tU32
*CAUTION:       Please note all the numbers passed to this function has to be 
*               unsigned integers i.e, numbers should be greater than or equal
*               to 0
* HISTORY:      
* Date           |   Author                            | Modifications    
*________________|_____________________________________|_______________________
*                |                                     | 
* 12-07-2007     | prc4kor (Pradeep Chand(RBIN/EDI3))  | Initial Version
******************************************************************************/
inline tU32 u32GetBits(tU32 u32Num_shift, tU16 u16Pos, tU16 u16Num_bits) 
{ 
    return (tU32)(((tU32)u32Num_shift >> ((tU32)u16Pos + (tU32)1 - (tU32)u16Num_bits)) & ~((tU32)(~0) << (tU32)u16Num_bits)); 
}
#endif //VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG

#endif//_HELP_FUNCTIONS

