/************************************************************************
* FILE:           tun_Diagnostics.cpp
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All Diagnostics related actions will be performed here.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 25.07.06  | ( RBIN ) Pushpa M.Hulimani   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------


//#include "..\fc_tmctuner_if.h"

// Include generic message
#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

// use AIL template with MessageMaps
#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

// use Application Help Library
#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#include "tun_PrjConfig.h"

// Access to unorganised traces
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#include "tun_defines.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_ERRORCODES

#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 
/*----------------------------------------------------------------------*/


#include "tun_Diagnostics.h"

#include "tun_Diag_defines.h"

#include "tun_ActualData.h"

#include "tun_Utility.h"

#include "tun_MessageQ.h"

#include "tun_Config.h"


#include "tun_MsgToADR.h"

#include "tun_DiagManager.h"

#include "tun_main.h"

#include "tun_Config.h"

#include "tun_MsgDefines.h"

#include "tun_HMIManager.h"

#include "tun_diagHelpFn.h"

#include "tun_Diaglog.h"

#include "kdsconfig/clConfigInterface.h"

// MESSAGE MAP:
// Function IDs (FID) corresponding to functions.
// The function will be called when a message with the corresponding FID arrives

BEGIN_MSG_MAP(tun_DiagService, ahl_tclBaseWork)
  //Method and Property for ADR Container
  ON_MESSAGE(MIDW_TUNDIAGFI_C_U16_FID_TUN_S_ADR_CONTAINER,        vHandleADR_Container)  
END_MSG_MAP()


/*************************************************************************
 *
 *FUNCTION:     tun_DiagService::tun_DiagService
 *
 *DESCRIPTION:  
 *              
 *             
 *PARAMETER:    
 *
 *RETURNVALUE:  None
 *
 *
 ************************************************************************/
 tun_DiagService::tun_DiagService(tuner_tclApp* poCCAMainApp):m_potun_DiagManager(NULL),\
                                                              m_potun_MsgToADR(NULL),\
                                                              m_potun_Config(NULL),\
                                                              m_poclConfigInterface(NULL),\
                                                              m_potun_DiaglogHandler(NULL),
                                                              m_potun_ActualData(NULL),\
                                                              m_potun_HMIManager(NULL)
{

   poGWMain     = poCCAMainApp;
}

/*************************************************************************
 *
 *FUNCTION:     tun_DiagService::~tun_DiagService
 *
 *DESCRIPTION:  
 *              
 *             
 *PARAMETER:    
 *
 *RETURNVALUE:  None
 *
 *
 ************************************************************************/
 tun_DiagService::~tun_DiagService()
{

    poGWMain     = NULL;

    m_potun_DiagManager = NULL; 
    
    m_potun_MsgToADR = NULL;

    m_potun_Config = NULL; 

    m_potun_DiaglogHandler = NULL;

    m_potun_HMIManager = NULL;

    m_potun_ActualData = NULL;

    m_poclConfigInterface = NULL;
}

/*************************************************************************
 *
 *FUNCTION:     tun_DiagService::vOnUnknownMessage
 *
 *DESCRIPTION:  Frame work calls this function when it receives a message with
 *              an unknown FID. Used for error handling.
 *             
 *PARAMETER:    poMessage : Pointer to CCA data
 *
 *RETURNVALUE:  None
 *
 ************************************************************************/
tVoid tun_DiagService::vOnUnknownMessage(amt_tclBaseMessage* /*poMessage*/)
{
  
}

/*************************************************************************
*
* FUNCTION:     tun_DiagService::vSet_tun_DiagManager_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tun_DiagManager*
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagService::vSet_tun_DiagManager_Ptr( tun_DiagManager* potun_DiagManager)
{
  if( potun_DiagManager != NULL )
  {  
    m_potun_DiagManager = potun_DiagManager;
  }
  else
  {
    NORMAL_M_ASSERT ( potun_DiagManager != NULL );

  }
}

/*************************************************************************
*
* FUNCTION:     tun_DiagService::vSet_tun_MsgToADR_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tun_MsgToADR*
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagService::vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR)
{
  if( potun_MsgToADR != NULL )
  {  
    m_potun_MsgToADR = potun_MsgToADR;
  }
  else
  {
    NORMAL_M_ASSERT ( potun_MsgToADR != NULL );

  }
}

/*************************************************************************
*
* FUNCTION:     tun_DiagService::vSet_tun_Config_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tun_Config*
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagService::vSet_tun_Config_Ptr( tun_Config* potun_Config)
{
  if( potun_Config != NULL )
  {  
    m_potun_Config = potun_Config;
  }
  else
  {
    NORMAL_M_ASSERT ( potun_Config != NULL );

  }
}

/*************************************************************************
*
* FUNCTION:     tun_DiagService::vSet_tun_ConfigInterface_Ptr( )
*
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagService::vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface )
{
  if( poclConfigInterface != NULL )
  {
	  m_poclConfigInterface = poclConfigInterface;
  }

}

/******************************************************************************
* FUNCTION: tun_DiagService::vSet_tun_ActualData_Ptr( )
* 
* DESCRIPTION: Sets a pointer to the class tun_ActualData
*
* PARAMETER: tun_ActualData*
*
* RETURNVALUE: None
******************************************************************************/
tVoid tun_DiagService::vSet_tun_ActualData_Ptr(tun_ActualData* potun_ActualData)
{
	if( NULL != potun_ActualData )
    {
		m_potun_ActualData = potun_ActualData;
    }
    else
    {
		NORMAL_M_ASSERT ( potun_ActualData != NULL );
    }
}
/******************************************************************************
* FUNCTION: tun_DiagService::vSet_tun_HMIManager_Ptr( )
* 
* DESCRIPTION: Sets a pointer to the class tun_HMIManager   
*
* PARAMETER: tun_HMIManager*
*
* RETURNVALUE: None
******************************************************************************/
tVoid tun_DiagService::vSet_tun_HMIManager_Ptr(tun_HMIManager* potun_HMIManager)
{
	if( NULL != potun_HMIManager )
    {
		m_potun_HMIManager = potun_HMIManager;
    }
    else
    {
		NORMAL_M_ASSERT ( potun_HMIManager != NULL );
    }
}
/*************************************************************************
*
* FUNCTION:     tun_DiagService::vSet_tun_DiaglogHandler_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    tun_Config*
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagService::vSet_tun_DiaglogHandler_Ptr(tun_DiaglogHandler* potun_DiaglogHandler)
{
  if( potun_DiaglogHandler != NULL )
  {  
    m_potun_DiaglogHandler = potun_DiaglogHandler;
  }
  else
  {
    NORMAL_M_ASSERT ( potun_DiaglogHandler != NULL );

  }
}

/*************************************************************************
 *
 *FUNCTION:     tun_DiagService::vOnNewAppState
 *
 *DESCRIPTION:  Main calls this function whenever there  is change in 
 *              power state to handle CCA service
 *             
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ************************************************************************/
/*tVoid tun_DiagService::vOnNewAppState ()
{  tU32 u32Appstate          = 0;
  //u32Appstate = poGWMain->u32GetRequestedAppState ();

  switch( u32Appstate )
  {
      
    case AMT_C_U32_STATE_NORMAL:
      { 
          //check for the Voltage values and the Component status
          // Inform the framework that we are ready to receive and send messages
          poGWMain->vServiceAvailabilityChanged    ( CCA_C_U16_SRV_TUNERDIAG     ,
                                                     AMT_C_U8_SVCSTATE_AVAILABLE );


      } // case AMT_C_U32_STATE_NORMAL:
      break;


    case AMT_C_U32_STATE_DIAGNOSIS:
      {
          //check for the Voltage values and the Component status
          // Inform the framework that Tuner is ready for communication
          poGWMain->vServiceAvailabilityChanged    ( CCA_C_U16_SRV_TUNERDIAG     ,
                                                     AMT_C_U8_SVCSTATE_AVAILABLE );

      } // case AMT_C_U32_STATE_DIAGNOSIS:
    break;

    case AMT_C_U32_STATE_PAUSE:
      {
            // Inform the framework that Tuner is ready for communication
            poGWMain->vServiceAvailabilityChanged    ( CCA_C_U16_SRV_TUNERDIAG     ,
                                                       AMT_C_U8_SVCSTATE_NOT_AVAILABLE );

      } // case AMT_C_U32_STATE_PAUSE:
      break;

    case AMT_C_U32_STATE_OFF:
      {
            // Inform the framework that Tuner is not ready for communication
            poGWMain->vServiceAvailabilityChanged    ( CCA_C_U16_SRV_TUNERDIAG     ,
                                                       AMT_C_U8_SVCSTATE_NOT_AVAILABLE );

      }
      break;

    default:
      {
        //add trace here
      }
      break;

  }//switch 

}*/

/*************************************************************************
 *
 *FUNCTION:     tun_DiagService::vSendError
 *
 *DESCRIPTION:  sends an error - message
 *             
 *PARAMETER:    data for addressing the message
 *
 *RETURNVALUE:  None
 *
 *
 ************************************************************************/
tVoid tun_DiagService::vSendError(tU16 u16SourceID,
                                  tU16 u16TargetID,
                                  tU16 u16RegisterID,
                                  tU16 u16CmdCounter,
                                  tU16 u16Sid,
                                  tU16 u16Fid,
                                  tU8  u8ErrorCode)
{

   gm_tclU8Message oErrorMsg(     u16TargetID,
                                  u16SourceID,
                                  u16RegisterID,
                                  u16CmdCounter,
                                  u16Sid,
                                  u16Fid,
                                  AMT_C_U8_CCAMSG_OPCODE_ERROR);
      

   oErrorMsg.vSetByte(u8ErrorCode);


   if(poGWMain->enPostMessage(&oErrorMsg, TRUE) != AIL_EN_N_NO_ERROR)
   {
      //Trace for Error message if required.
   }

}


/****************************************************************************
*FUNCTION:    tun_DiagService::vSendMessage
*
*DESCRIPTION: This function converts Amt message to visitor class and 
*             get the data from visitor to the Fi class. Refer FI Manual.Doc.
*
*PARAMETER:    
*             u16DestAppID      - Destination ID of Out Msg  
*             oOutData          - Base class of out going Fi object
*             u16Fid            - Funtion id of the out going message
*             u8OpCode          - Opcode of the message 
*
*RETURNVALUE: None
******************************************************************************/
tVoid tun_DiagService::vSendMessage( tU16             u16DestAppID,
                                     const fi_tclTypeBase&  oOutData,
                                     tU16             u16Fid,
                                     tU8              u8OpCode,
                                     tU16             u16CmdCtr,
                                     tU16             u16RegId)
{
   // Create the Visitor Message
   fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);

   // Set the CCA message information
   oOutVisitorMsg.vInitServiceData(
         CCA_C_U16_APP_TUNER,                      /* Source app-ID    */
         u16DestAppID,                             /* Dest. app-ID     */
         AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type      */
         0,                                        /* stream counter   */
         u16RegId,                                 /* Registry ID      */
         u16CmdCtr,                                /* Command counter  */
         CCA_C_U16_SRV_TUNERDIAG,                  /* Service-ID       */
         u16Fid,                                   /* Function-ID      */
         u8OpCode,                                 /* OpCode           */
         0,                                        /* ACT              */
         0,                                        /* Source sub-ID    */
         0 );                                      /* Dest. sub-ID     */

  // Send it to the client 
  if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
  {
    //Trace for Error message if required.
  }

}



/*******************************************************************************
*FUNCTION:    tun_DiagService::vGetDatafromAMT
*
*DESCRIPTION: This function converts Amt message to visitor class and 
*             get the data from visitor to the Fi class. Refer FI Manual.
*             Doc.
*
*PARAMETER:    
*           poFiMsg   - Amt Message 
*           oFIData   - Base class of Fi class 
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_DiagService::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
                                        fi_tclTypeBase&     oFIData ) const
{
   // Create Visitor message object for incoming message
   fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

   /* Get the data in FI class from Vistor class*/   
   if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
   {
      // assert here 
      NORMAL_M_ASSERT_ALWAYS ();
   }

}


/******************************************************************************
*
* FUNCTION: tVoid tun_DiagService::vSendAnswer
*           ( const amt_tclServiceData* poMessage, tU8 u8Data,
*           tU8 u8Opcode )
* 
* DESCRIPTION: Sends the required data to a client
*
* PARAMETER: Message to be answered, data, opcode of the answer
*
* RETURNVALUE: tVoid
*
******************************************************************************/

tVoid tun_DiagService::vSendAnswer
(
 const amt_tclServiceData* poMessage,
 tU8 u8Data , 
 tU8 u8Opcode
)
{
	//OS_TRACE(1);
    /* +++   create a message using the data of given message to get the
    address information    +++ */
    gm_tclU8Message oStatusMsg = gm_tclU8Message
                                  ( 
                                      CCA_C_U16_APP_TUNER, 
                                      poMessage->u16GetSourceAppID(),
                                      poMessage->u16GetRegisterID(),
                                      poMessage->u16GetCmdCounter(),
                                      CCA_C_U16_SRV_TUNERDIAG,
                                      poMessage->u16GetFunctionID(),
                                      u8Opcode
                                  );
    oStatusMsg.vSetTargetSubID(poMessage->u16GetSourceSubID());
    /* +++   fill in your data   +++ */
    oStatusMsg.vSetByte( u8Data );

    /* ---   send it to the client    --- */
    if( NULL != poGWMain )
    {
      if( AIL_EN_N_NO_ERROR != poGWMain->enPostMessage( &oStatusMsg, TRUE ) )
      {
        /* +++         can't send status:  enter error handling here 
        ( trace or assert ) +++ */
      }
    }
}
/*******************************************************************************
*FUNCTION:    tun_DiagService::vSendGenMessage
*
*DESCRIPTION: This is to send the Message through CCA
*             
*
*PARAMETER:   amt_tclServiceData
*           
*
*RETURNVALUE: None
********************************************************************************/
tVoid tun_DiagService :: vSendGenMessage(amt_tclServiceData poMessage)
{

  if( NULL != poGWMain )
    {
     if(poGWMain->enPostMessage( &poMessage, TRUE ) != AIL_EN_N_NO_ERROR)
     {
        /* +++
        can't send status:
        enter error handling here ( trace or assert )
        +++ */
        ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DIAG_SRV, 
                            ET_EN_T16 _ poMessage.u16GetFunctionID() _\
                            ET_EN_T16 _ TUN_TRACE_MSG_POST_FAIL_ERR _ \
                            ET_EN_DONE );
     }
     else 
     {
       //Message sending succesfull

        ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAG_SRV , ET_EN_T16 _ 0xff _  
                                                      ET_EN_DONE); 
     }
    }
}


                                               
                                                 
/******************************************************************************
*
* FUNCTION: tVoid tun_DiagService::vHandleADR_Container( )
* 
* DESCRIPTION: Sends the request to ADR
*
* PARAMETER: Message to be answered, data, opcode of the answer
*
* RETURNVALUE: tVoid
*
* HISTORY:      
* Date      | Author                   
* 6.3.07    | ( RBIN )she4kor        
******************************************************************************/        
tVoid tun_DiagService ::vHandleADR_Container(amt_tclServiceData* poMessage)
{
 //  validate Pointers
    if( NULL == m_potun_DiagManager)
    {
      NORMAL_M_ASSERT (NULL != m_potun_DiagManager);
    }
  
    else if( m_potun_MsgToADR == NULL )    
    {
      NORMAL_M_ASSERT( m_potun_MsgToADR != NULL );

    } 

    else if( NULL == poMessage)
      {
        NORMAL_M_ASSERT (NULL != poMessage);
      }

    else
    {
    
    switch (poMessage->u8GetOpCode())
    {
      
    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART: 
      {
		  m_potun_DiagManager->vSetDiagCommandCntr(poMessage->u16GetCmdCounter());
		  m_potun_DiagManager->vSetDiagRegID(poMessage->u16GetRegisterID());
		  
          //  we have to get a message of this type
          midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodStart omessage;
          tU8 u8DataLength = 0;//initialised to solve prio3 lint warning
          tU8 u8DataSpecial[TUN_DIAG_ATM_CONTAINER_MAX] = {0};//initialised to solve prio3 lint warning
          
          // Make a visitor object to get the data
          vGetDatafromAMT ( poMessage,omessage);
          u8DataLength = omessage.u8DataLength;
          for(tU8 u8Arrayindex = 0;u8Arrayindex < u8DataLength;u8Arrayindex++)
          {
            u8DataSpecial[u8Arrayindex] = omessage.GenericBytes[u8Arrayindex];
          }
          
          m_potun_MsgToADR -> vSendSetATMContainer(u8DataLength,u8DataSpecial);        

          ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAG_SRV ,\
                              ET_EN_T16 _ MIDW_TUNDIAGFI_C_U16_FID_TUN_S_ADR_CONTAINER _\
                              ET_EN_T8 _ TUN_TRACE1 _\
                              ET_EN_T8 _ u8DataLength _\
                              ET_EN_T32 _ u8DataSpecial _\
                              ET_EN_DONE);

      }
      break;
      default:
      {
      /* +++
      unkown opcode:
      enter error handling here ( trace or assert )
        +++ */     
        break;
      }

    }

   }
}



           
