/************************************************************************
 * FILE:         tun_Diaglog.cpp
 * PROJECT:      g3g
 * SW-COMPONENT: FC_TMCTUNER server
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: The diaglog is used to write trouble code status messages
 *              FM SEEK (antenna Test)
 *
  *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author             | Modification
 * 10.08.06  | RBIN/EDI1 PUSHPA   | initial version
 * 25.04.13  | NGP1KOR    | First version of the G3g after porting
				from NISSAN LCN2Kai
 *************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

// Include generic messages

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h" 
#endif


// use Application Help Library
#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

// Use OSAL defines
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


// Include Diaglog interface
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"


#include "tun_Diaglog.h"
#include "tun_diagHelpFn.h"

#include "tun_main.h"
#include "tun_trace.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/tun_Diaglog.cpp.trc.h"
#endif
#include "tun_MsgToADR.h"
/*************************************************************************
 *
 * FUNCTION:     tun_DiaglogHandler::tun_DiaglogHandler
 *
 * DESCRIPTION:  constructor, creates object tun_DiaglogHandler
 *
 * PARAMETER:    poGWMainApp: main - object of this application
 *
 * RETURNVALUE:  None
 *************************************************************************/
tun_DiaglogHandler :: tun_DiaglogHandler(tuner_tclApp* poMainApp) :
m_u16RegID(AMT_C_U16_REGID_INVALID)
{
	poGWMain      = poMainApp;

}
/*************************************************************************
 *
 * FUNCTION:     tun_DiaglogHandler::~tun_DiaglogHandler
 *
 * DESCRIPTION:  destructor, destroys the object
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  None
 ************************************************************************/
tun_DiaglogHandler :: ~tun_DiaglogHandler()
{
	poGWMain     = NULL;
	m_u16RegID	=AMT_C_U16_REGID_INVALID;
}
/*************************************************************************
 *
 * FUNCTION:     tun_DiaglogHandler::vOnUnknownMessage
 *
 * DESCRIPTION:  Frame work calls this function when it receives a message with
 *               an unknown FID. Used for error handling.
 *
 * PARAMETER:    amt_tclBaseMessage*
 *
 * RETURNVALUE:  None
 *************************************************************************/
tVoid tun_DiaglogHandler :: vOnUnknownMessage(amt_tclBaseMessage* /*poMessage*/)
{
	
}
/*************************************************************************
 *
 * FUNCTION:     tun_DiaglogHandler::vOnNewAppState
 *
 * DESCRIPTION:  Main calls this function whenever there is a change in
 *               power state to handle CCA service
 *
 * PARAMETER:    tU32 u32OldAppState, tU32 u32AppState
 *
 * RETURNVALUE:  None
 *************************************************************************/
tVoid tun_DiaglogHandler :: vOnNewAppState ( tU32 u32OldAppState,  tU32 u32AppState )
{
	if(u32OldAppState==u32AppState)
	{
		return;
	}
	switch(u32AppState)
	{
	case AMT_C_U32_STATE_NORMAL:
	{
		vRegisterForService();
		break;
	}
	case AMT_C_U32_STATE_OFF:
	{
		vUnregisterForService();
		break;
	}
	default:
		{
			break;
		}
	}

}
/*************************************************************************************
 *
 *FUNCTION:     tun_DiaglogHandler::vOnServiceState
 *
 *DESCRIPTION:  Handles the state changes of the service we use
 *
 *PARAMETER:    tU16,tU16,tU16,tU8,tU16,
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tun_DiaglogHandler :: vOnServiceState(   tU16  u16ServiceId ,
		tU16  u16ServerId ,
		tU16  u16RegisterId,
		tU8   u8ServiceState,
		tU16  u16SubId      )
{
	if(u16ServiceId  !=  CCA_C_U16_SRV_DIAGLOG)
	{
		return;
	}
	m_u16RegID = u16RegisterId;
	switch(u8ServiceState)
	{
	case AMT_C_U8_SVCSTATE_REG_INVALID:
	{
		vRegisterForService();
		break;
	}
	default:
	{
		break;
	}
	}
	ETG_TRACE_USR1(("vOnServiceState()->"
			"ServiceId=%d u16ServerId=%d RegisterId=%d ServiceState=%d SubId=%d",
			u16ServiceId,u16ServerId,u16RegisterId,u8ServiceState,u16SubId));
}
/*************************************************************************************
 *
 *FUNCTION:     tun_DiaglogHandler::vRegisterForService
 *
 *DESCRIPTION:  Sends a register message to Diaglog
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tVoid
 ************************************************************************************/
tVoid tun_DiaglogHandler::vRegisterForService()
{
	if ( NULL == poGWMain )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		return;
	}
	if ( AMT_C_U16_REGID_INVALID == m_u16RegID )
	{
		tBool bRetVal = poGWMain->bRegisterAsync (CCA_C_U16_SRV_DIAGLOG,
				MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION                     /* Major version */,
				0                      /* Minor version */,
				0x0,
				CCA_C_U16_APP_DIAGLOG
		);
		ETG_TRACE_ERR(("vRegisterForService()-> Returns=%d",bRetVal));
	}
}
/*************************************************************************************
 *
 *FUNCTION:     tun_DiaglogHandler::vUnregisterForService
 *
 *DESCRIPTION:  Sends a unregister message to Diaglog
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tBool
 ************************************************************************************/
tVoid tun_DiaglogHandler::vUnregisterForService()
{
	if ( AMT_C_U16_REGID_INVALID != m_u16RegID )
	{
		if ( NULL == poGWMain )
		{
			NORMAL_M_ASSERT (NULL != poGWMain);
			return;
		}
		poGWMain->vUnregisterService(CCA_C_U16_SRV_DIAGLOG );
		m_u16RegID = AMT_C_U16_REGID_INVALID;
	}
}
/*************************************************************************************
 *FUNCTION:    tun_DiaglogHandler::vSendMessage
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.Doc.
 *
 *PARAMETER:    tU16,fi_tclTypeBase& ,tU16,tU8,tU16,tU16
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tun_DiaglogHandler :: vSendMessage( tU16             u16DestAppID,
		const fi_tclTypeBase&  oOutData,
		tU16             u16Fid,
		tU8              u8OpCode,
		tU16             u16CmdCtr,
		tU16             u16RegId)
{
	fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);
	oOutVisitorMsg.vInitServiceData(  CCA_C_U16_APP_TUNER,                  /* Source app-ID    */
			u16DestAppID,                         /* Dest. app-ID     */
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    /* stream type      */
			0,                                    /* stream counter   */
			u16RegId,                             /* Registry ID      */
			u16CmdCtr,                            /* Command counter  */
			CCA_C_U16_SRV_DIAGLOG,                /* Service-ID       */
			u16Fid,                               /* Function-ID      */
			u8OpCode,                             /* OpCode           */
			0,                                    /* ACT              */
			0,                                    /* Source sub-ID    */
			0 );                                  /* Dest. sub-ID     */


	if ( NULL == poGWMain )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		return;
	}
	if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
	{
		ETG_TRACE_ERR(("enPostMessage()-> NOK"));
	}

}
/*************************************************************************************
 *FUNCTION:    tun_DiaglogHandler::vGetDataFromAmt
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:   amt_tclServiceData*   : Amt Message
 *             fi_tclTypeBase&       : Base class of Fi class
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tun_DiaglogHandler :: vGetDataFromAmt ( amt_tclServiceData*  poFIMsg,
		fi_tclTypeBase&  oFIData )const
{
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		NORMAL_M_ASSERT_ALWAYS ();
	}
}
tVoid tun_DiaglogHandler::vUpdateTunerSystemFailureErrorLog(tBool blUpdateSystemFailure)
{
	midw_diaglogfi_tclMsgSaveTestResultMethodStart oMsg;
	midw_fi_tcl_TestResult oTestResult;
	oTestResult.TroubleCode = ITC_AMFM_TUNER1_SYSTEM_FAILURE;
	oTestResult.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
	if(blUpdateSystemFailure)
	{
		oTestResult.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
	}
	oMsg.TestResultList.TestResultList.push_back (oTestResult);
	vSendMessage ( CCA_C_U16_APP_DIAGLOG,
		oMsg,
		MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT,
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
		0,
		m_u16RegID );
	ETG_TRACE_USR1(("vUpdateTunerSystemFailureErrorLog()->ITC AMFM_TUNER1_SYSTEM_FAILURE is updated with =%d",oTestResult.Result.enType));

}
