/************************************************************************
* FILE:           tun_Diag_defines.h
* PROJECT:        Ford H/L RNS
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All headers specific to Tuner component.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 5.8.06    | RBIN/EDI1 Pushpa             | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#ifndef TUN_DIAG_DEFINES_H
#define TUN_DIAG_DEFINES_H

/*---------------------------------------*/
/* defines used in class tun_DiagManager */
/*---------------------------------------*/
#define TUNER_DIAG_FUNID_CARRAY_SIZE           5 
//#define TUNER_DIAG_FUNID_NOTARRAY_SIZE         10

#define TUNER_DIAG_NOTTABLE_SEM_NAME    "TUNER_DAIG_NOTTABLESEM"

#define TUN_DIAG_NO_TROUBLE_CODES 0x01
#define TUN_C_DIAG_ATM_CONTAINER_LEN  35
#define TUN_DIAG_ATM_CONTAINER_MAX  32


//#define    FID_TUN_S_PERFORM_TEST  0x0001
//#define    FID_TUN_S_SEND_FIELDSTRENGTH  0x0002
//#define    FID_TUN_G_SEND_ERRORSTATUS  0x0003
//#define    FID_TUN_G_SEND_FIELDSTRENGTH  0x0004
/* Used for State handling of the Diagnostics requests */
#define TUN_FID_NUMBER 5
#define TUN_FID_STATUS 2

#define TUN_FEATURE_DISABLE 0

#define TUN_AF_LIST_TEN 10 //for AF list

/* Used for State handling of the Diagnostics requests */
enum T_e8_FidRequest {
  FID_NOT_REQUESTED     = 0,
  FID_REQUESTED         = 1,
  FID_HANDLING_STARTED  = 2,
  FID_HANDLING          = 3,
  FID_HANDLED           = 4
};


enum Tun_MonitorMode {
  TUNER_MONITORING_OFF = 0UL,
  TUNER_MONITORING_CONTINUOUS = 1UL,
  TUNER_MONITORING_SINGLE = 2UL,
  TUNER_MONITORING_PREVIOUSMODE = 4UL
};

enum Tun_SupervisionControl {
   TUNER_SUPERVISION_DEFAULT = 0UL,
   TUNER_SUPERVISION_OFF = 1UL,
   TUNER_SUPERVISION_ON = 2UL
};

enum Tun_ErrorStatus {
   TUNER_TEST_PASSED = 0UL,
   TUNER_TEST_FAILED = 1UL,
   TUNER_TEST_NEVER_RAN = 2UL
};

enum Tun_RoutineStatus {
   TUNER_ROUTINE_NOT_RUNNING = 0UL,
   TUNER_ROUTINE_RUNNING = 1UL,
   TUNER_ROUTINE_FINISHED = 2UL,
   TUNER_ROUTINE_CANCELLED = 3UL 
};


typedef struct
{
  // Trouble codes associated parameters  
  tU8   u8MonitorMode[TUN_DIAG_NO_TROUBLE_CODES];
  tBool fReportToRM[TUN_DIAG_NO_TROUBLE_CODES];
  tU8   u8Supervision[TUN_DIAG_NO_TROUBLE_CODES];
  tBool fIsTCRequested[TUN_DIAG_NO_TROUBLE_CODES];

}TunerDiagTestStruct;

// Structure for status reporting to diag
typedef struct
{
  // Trouble codes associated parameters  
  tU16 u16TroubleCode [TUN_DIAG_NO_TROUBLE_CODES];
  tU8 u8ErrorStatus[TUN_DIAG_NO_TROUBLE_CODES];
  tU8 u8RoutineStatus[TUN_DIAG_NO_TROUBLE_CODES];

} TunerDiagErrorStruct;

#define FIELDSTRENGTH 0x00


enum {
   TUNER_UNSPECIFIED = 0x00 ,
   TUNER_UNKNOWNSVCID = 0x01,
   TUNER_UNKNOWNFCTID = 0x02,
   TUNER_INVALIDOPCODE = 0x03,
   TUNER_INVALIDCCATYPE = 0x04,
   TUNER_PARAMETEROUTOFRANGE = 0x05,
   TUNER_UNKNOWNREGID = 0x06,
   TUNER_VERSIONNOTSUPPORTED = 0x07,
   TUNER_PARAMETERMISSING = 0x08,
   TUNER_PARAMETERTOOMANY = 0x09,
   TUNER_BUSY = 0x0A,
   TUNER_TEMPORARYNOTAVAILABLE = 0x0B,
   TUNER_OPCODENOTSUPPORTED = 0x0C,
   TUNER_INTERNALFAILURE = 0x0D,
   TUNER_UPREGFAILURE = 0x0E,
   TUNER_RELUPREGFAILURE = 0x0F
};

enum Tun_DiagResult {
    TUN_TEST_PASSED = 0UL,
    TUN_TEST_FAILED = 1UL,
    TUN_TEST_NO_RESULT = 2UL,
    TUN_TEST_PASSEDDIAG = 3UL,
    TUN_TEST_FAILEDDIAG = 4UL,
    TUN_TEST_NO_RESULTDIAG = 5UL
};

// Type for the Diag_mode feature
typedef struct
{
  tU8   u8DiagModeFeature;
  tU8   u8DiagModeMask;

}TunerSetDiagModeStatus;

/*---------------------------------------------*/
/* defines used in for Tuner align calibration */
/*---------------------------------------------*/
#define TUN_SET_DIAG_MODE_CONST      0x3F

#define TUN_ALIGN_FREQ1              90000
#define TUN_ALIGN_FREQ2              104000

#define TUN_CALIBRATE_FM_FREQ1       97100
#define TUN_CALIBRATE_FM_FREQ2       107900

#define TUN_CALIBRATE_AM_FREQ        9000

#define ALIGN_TUN1                   0x01
#define ALIGN_TUN2                   0x02
#define ALIGN_TUN1_AND_2             0x03

#define ALIGNMENT_STEP1              0x00
#define ALIGNMENT_STEP2              0x01

#define ANTENNA_OK                           0x00
#define ANTENNA_ERR_SHORT                    0x01
#define ANTENNA_ERR_DISCON_IMP               0x02
#define ANTENNA_ERR_DISCON_ANT               0x04
#define ANTENNA_ERR_PASSIVE                  0x06

#define PHANTOM_ANTENNA1             0x00
#define PHANTOM_ANTENNA2             0x02
#define PHANTOM_DAB_ANTENNA			 0x03 

#define TUN_SET_ANTENNA1             0x01
#define TUN_SET_ANTENNA2             0x02

#define RCTRL_SAVE                      0x01
#define RCTRL_RESTRORE                  0x02

#define TUN_TRACE1                        0x01
#define TUN_TRACE2                        0x02

#endif
