/************************************************************************
* FILE:           tun_DiagManager.h
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All Diagnostics related actions will be performed here.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 3.08.06   | ( RBIN ) Pushpa M.Hulimani   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#ifndef TUN_DIAGMANAGER_H
#define TUN_DIAGMANAGER_H

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

#include "tun_PrjConfig.h"

#include "tun_Diag_defines.h"

#include "tun_Diagnostics.h"


#include "tun_PrjConfig.h"

#include "tun_Class_ForwardDecl.h"
#include "tun_diaghandler.h"


class tun_DiagManager
{
  // Access to main app
  tuner_tclApp*                poGWMain;

  template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
  /* this function must not be used, therefore it is private */
   tun_DiagManager& operator=(const tun_DiagManager& c);

    //Store the diagnosis register ID- to be used to send Method result for Remote control Method
    tU16 u16DiagRegID;

    //Store the diagnosis command counter- to be used to send Method result for Remote control Method
    tU16 u16CommandCntr;

public:

  tun_DiagManager( tuner_tclApp*  potunerMainApp );
  tun_DiagManager();// default constructor added for removing lint prio3 warning
  /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
   tun_DiagManager(const tun_DiagManager& c);

  ~tun_DiagManager();
  
  tun_DiagService* m_potun_DiagService ;

  tun_MsgToADR* m_potun_MsgToADR;

  tun_Utility* m_potun_Utility;

  tun_DiaglogHandler* m_potun_DiaglogHandler;

  tun_tclDiagHandler* m_potun_tclDiagHandler;

  tVoid vSet_tun_Diagnostics_Ptr( tun_DiagService* potun_DiagService );

  tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR);

  tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility);

  tVoid vSet_tun_DiaglogHandler_Ptr( tun_DiaglogHandler* potun_DiaglogHandler);

  tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );

  tVoid vHandleMessagesfromRU (tU8* pu8Message, tU32 u32MessageLen);
  
  tVoid vSet_tun_DiagHandler_Ptr(tun_tclDiagHandler* potun_tclDiagHandler);

  tVoid vHandleADRContainer(const tU8* pu8Message, tU32 u32MessageLen);

  tVoid vSetDiagRegID(tU16 u16RegID);

  tU16 u16GetDiagRegID() const;

  tVoid vSetDiagCommandCntr(tU16 u16ComCntr);

  tU16 u16GetDiagCommandCntr() const;
};

#endif




