/************************************************************************
* FILE:         ipod_selftesthandler.h
* PROJECT:      g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Example implementation of a routine control listener
* that provides access to demodata. The difference of this example
* compared to a realworld usecase is the fact, that usually for a routine
* control you would have longer running tests.
* In case of longer running tests you probably delegate a test request to
* a worker thread. It is no problem to send the response from this worker
* thread instead of how it is done in this example. When you have a worker
* thread the RoutineControlAbort functionality also makes more sense :)
* See general documentation, when you have questions on the sequence of
* a test that you have to implement or consult diagnosis team.
* Anyway take this class as a template for your own listener classes and
* adjust the parts marked with
* // +++ comment +++
*
* - ccademo_diaghandler.x              => // +++ Comment +++
* - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
* - ccademo_main.x                     => // +++diaglib+++ comment
* - ccademo_msgtypes.h                 => // +++diaglib+++ comment
*              
* *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                 | Modification
* 15.07.08  | CM-AI/PJ-FO45 Evers    | Inital version
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/
#ifndef TUN_TCLLISTENER_H
#define TUN_TCLLISTENER_H



// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_SYSTEM_SET
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
//#include "../fc_diagnosis/diaglib/diaglib_if.h"
#include "diaglib_if.h"

#include "tun_main.h"
#include "tun_MsgToADR.h"


//class tuner_tclApp; //lint !e763 prio3 reviewed: 763 this is not redundant; forward declaration is important to resolve dependecies

// +++ Default value of testdata +++
//#define IPOD_SELFTESTRESULT_DEFAULT 0xffffffff

// +++diaglib+++ Create defines for the IDs you support, later there might be a header file in diaglib +++

/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */
// +++ Adjust class prefix +++
class tun_tclConfigAntennaListener : public diaglib::tclRoutineControlListenerIF
{

public:
   // +++ Depending on the type of listener you need the associated interface to send responses +++
   tun_tclConfigAntennaListener(tuner_tclApp* poMainApp);
   virtual ~tun_tclConfigAntennaListener();

private:
   //forbidden
   tun_tclConfigAntennaListener(const tun_tclConfigAntennaListener& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
   tun_tclConfigAntennaListener& operator=(const tun_tclConfigAntennaListener& rhs);
   

   // +++ Pointer to application +++
   tuner_tclApp* m_potun_Main;
   tun_Config* m_potun_Config;
   tun_MsgToADR* m_potun_MsgToADR;

   //SelfTest result
   //tU32  _u32SelfTestResult;
   //tBool _bSelfTestResultReady;
   //tBool _bSelfTestRunning;

 
   
   // +++ Interface pointer to send responses to, adjust type according to listener type +++
	diaglib::tclRoutineControlIF* _poRoutineCtrlIF;
	diaglib::tclSystemSetIF*		 m_poSystemSetIF;
	diaglib::tclDiagnosisIF*      m_poDiagIF;
	diaglib::tclDiagnosisInterfaceFactory* m_poFactory;
   
	diaglib::tContext m_MsgContext;
    tBool blStatusReceived;
	tBool m_blAntennaConfigResponse;
public:

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++
   /***************************************************************************
    * RoutineControlListener methods
    ***************************************************************************/
   


};
#endif 


