/************************************************************************
 * FILE:           clAars_MTCAudioSource.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_MTCAudioSource
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   14-Jan-2015         pad1cob

 *************************************************************************/



#include "clAars_MTCAudioSource.h"
#include "clAars_CM_UpdateLandscape.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_ActualData.h"
#include "tun_Config.h"
#include "tun_MsgFromHMI.h"
#include "tun_SPM_Client.h"
#include "tuner_trace.h"
#include "tun_MsgToADR.h"
#include "tun_defines.h"
#include "tun_main.h"
#include "tun_Manager.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_MTCAudioSource.cpp.trc.h"
#endif


clAars_MTCAudioSource::clAars_MTCAudioSource(){
	m_poGWMain = nullptr;
	m_potun_ActualData=nullptr;
	m_potun_Config=nullptr;
	m_poclConfigInterface=nullptr;
	m_potun_MsgFromHMI=nullptr;
	m_poclAars_CM_UpdateLandscape=nullptr;
}



clAars_MTCAudioSource::~clAars_MTCAudioSource(){
	m_poGWMain = nullptr;
	m_potun_ActualData=nullptr;
	m_potun_Config=nullptr;
	m_poclConfigInterface=nullptr;
	m_potun_MsgFromHMI=nullptr;
	m_poclAars_CM_UpdateLandscape=nullptr;
}





clAars_MTCAudioSource::clAars_MTCAudioSource(tuner_tclApp* poGWMain, tuner::AarsApp::clAarsHandler* poAarsHandler,tun_ActualData* potun_ActualData,tun_Config* potun_Config,clConfigInterface* poclConfigInterface, clAars_CM_UpdateLandscape* poclAars_CM_UpdateLandscape):
  tuner::AarsApp::clClientProperty(poAarsHandler, SBR_MSG_FID_CM_MTC_AUDIOSOURCE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){
    m_poGWMain = poGWMain;
	m_potun_ActualData=potun_ActualData;
	m_potun_Config=potun_Config;
	m_poclConfigInterface=poclConfigInterface;
	m_potun_MsgFromHMI=nullptr;
	m_poclAars_CM_UpdateLandscape = poclAars_CM_UpdateLandscape;
}


void clAars_MTCAudioSource::vStatus(tunerVector<unsigned char> &bitStream){

	if((nullptr ==m_potun_ActualData) || (nullptr==m_potun_Config)|| (nullptr==m_poclConfigInterface) || (nullptr==m_potun_MsgFromHMI) || (nullptr == m_poGWMain)
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		|| (nullptr == m_poclAars_CM_UpdateLandscape)
#endif
		)
	{
		return;
	}
	clADRInMsg oMsg(bitStream);
	clMTCATAudioSource oData;
	oMsg.vGetDataFromPayload(oData);
   /* Send landscape command only if ADR is in BG and system is in STANDBY mode and system should not be received OFF state */
	if((m_potun_ActualData->m_otun_Data_MainStatus.u32GetSystemState()==SPM_SYSTEM_STATE_STANDBY) && (oData.MTCAudioSource.enType==clCMEnum_MTCAudioSource::NotHeardSource) && m_poGWMain->m_potu_Manager->u8GetTunerSystemState() != AMT_C_U32_STATE_OFF)
	{
		if( m_potun_Config->fGetLandscapeSeekNeeded())
		{
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
			m_poclAars_CM_UpdateLandscape->vUpdateLandscape(m_poclConfigInterface->u32GetConfigData("AvailableBands"));
#endif
		}
	}

   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewTunerFGBGStatus((tU8)oData.MTCAudioSource.enType);
   if(oData.MTCAudioSource.enType == clCMEnum_MTCAudioSource::NotHeardSource)
   {
	   m_potun_MsgFromHMI->vSetTunerBand(0xff);
	   ETG_TRACE_USR4((" clAars_MTCAudioSource::vStatus, tunerInBG "));
   }
   /*set PWM values for BG, TA and PTY source to high frequency range, For User_audio it will be taken care after receving AtStationInfo status */
   if(oData.MTCAudioSource.enType == clCMEnum_MTCAudioSource::NotHeardSource || oData.MTCAudioSource.enType == clCMEnum_MTCAudioSource::Anno_audio_RDS || oData.MTCAudioSource.enType == clCMEnum_MTCAudioSource::PTY31_audio_RDS)
   {
	   /*Fix for - NCG3D-44370. Set PWM frequency if tuner is in BG to TUN_PWM_HIGH_CORRECTEDFREQUENCY*/
	   #ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			/*Set PWM12 to 50% duty cycle - NCG3D-44370*/
			m_poGWMain->vSetPWM(DUTYCYCLE_50 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
	   #else
			m_poGWMain->vSetPWM( DUTYCYCLE_100 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
	   #endif
	   ETG_TRACE_USR4((" clAars_MTCAudioSource::vStatus, tuner in %d, Corrected PWM Frequency = %d", oData.MTCAudioSource.enType, TUN_PWM_HIGH_CORRECTEDFREQUENCY));
   }

}


void clAars_MTCAudioSource::vSetAudioSource(clCMEnum_MTCAudioSource::enMTCAudioSource audioSource)
{

   ETG_TRACE_USR4(("clAars_MTCAudioSource::vSetAudioSource: %d", audioSource ));
   clMTCATAudioSource oData;
   oData.MTCAudioSource.enType = audioSource;
   vSetGet(oData);
}


void clAars_MTCAudioSource::vSettun_MsgFromHMIImpl(tun_MsgFromHMI* potun_MsgFromHMI)
{
	m_potun_MsgFromHMI=potun_MsgFromHMI;
}
