/************************************************************************
 * FILE:           clAars_HDTestMode.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_HDTestMode
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   09-Mar-2015			vnd4kor
				
 *************************************************************************/


#if !defined(clAars_HDTestMode_h)
#define clAars_HDTestMode_h

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "AarsApp/clClientProperty.h"

/**
 * @author vnd4kor
 * @version 1.0
 * @created 09-Mar-2015 10:20:45
 */
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_HDTestMode : public tuner::AarsApp::clClientProperty
{
private : 
	unsigned char m_u8TransitionCount;
	unsigned char m_u8HDStationInfoBits;
	
   bool bIsTransitionFromDigitalToAnalog(unsigned char u8HDStationInfoBits);
   bool bExtractHDBlendOnAnalogBit(unsigned char u8HDStationInfoBits);

public:
   clAars_HDTestMode();
   virtual ~clAars_HDTestMode();

   /**
    *
    * @param poAarsHandler
    */
   clAars_HDTestMode(tuner::AarsApp::clAarsHandler* poAarsHandler);
   void vSetHDTestMode(tU8 u8TestModeActivity);
   
   void vResetTransitionCount();
   void vHandleTransitionCount(unsigned char u8HDStationInfoBits);


 
protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);

};

#endif // !defined(clAars_HDTestMode_h)
