/************************************************************************
 * FILE:           clAars_HDTestMode.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   implementation of the Class clAars_HDTestMode
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   10-Mar-2015			vnd4kor
				
 *************************************************************************/



#include "clAars_HDTestMode.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_HDTestMode.cpp.trc.h"
#endif


#define TUN_HD_BLEND_OVER_ANALOG_MASK 0x08

clAars_HDTestMode::clAars_HDTestMode():m_u8TransitionCount(0),m_u8HDStationInfoBits(0){

}



clAars_HDTestMode::~clAars_HDTestMode(){

}




clAars_HDTestMode::clAars_HDTestMode(tuner::AarsApp::clAarsHandler* poAarsHandler): 
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_HD_TESTMODE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

	m_u8TransitionCount=0;
	m_u8HDStationInfoBits=0;

}

  
void clAars_HDTestMode::vSetHDTestMode(tU8 u8TestModeActivity)
{
	ETG_TRACE_USR4(("clAars_HDTestMode::vSetHDTestMode: %d", u8TestModeActivity ));
	clCMHDTestModeSet oData;
	oData.setTestmodeActivity((clCMEnum_TestmodeActivity::enTestmodeActivity)u8TestModeActivity);
	vSet(oData);
}

void clAars_HDTestMode::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMHDTestModeStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_HDTestMode::vStatus: Instance ID : %d",oMsg.getHeader().getu8InstanceId() ));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewATHDTestModeStatus(oData,oMsg.getHeader().getu8InstanceId(),m_u8TransitionCount);
}


void clAars_HDTestMode::vResetTransitionCount()
{
	m_u8TransitionCount=0;
	m_u8HDStationInfoBits=0;
}

void clAars_HDTestMode::vHandleTransitionCount(unsigned char u8HDStationInfoBits)
{
	if(bIsTransitionFromDigitalToAnalog(u8HDStationInfoBits))
	{
		m_u8TransitionCount++;
	}
	m_u8HDStationInfoBits = u8HDStationInfoBits;
}

bool clAars_HDTestMode::bIsTransitionFromDigitalToAnalog(unsigned char u8HDStationInfoBits)
{
	if(bExtractHDBlendOnAnalogBit(m_u8HDStationInfoBits) > bExtractHDBlendOnAnalogBit(u8HDStationInfoBits))
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool clAars_HDTestMode::bExtractHDBlendOnAnalogBit(unsigned char u8HDStationInfoBits)
{
	return (u8HDStationInfoBits & TUN_HD_BLEND_OVER_ANALOG_MASK) ? true: false; 
}
