/************************************************************************
 * FILE:            clAars_HDFirmwareInfo.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_HDFirmwareInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   12-Mar-2015			vnd4kor
				
 *************************************************************************/


#if !defined(clAars_HDFirmwareInfo_h)
#define clAars_HDFirmwareInfo_h

#include "AarsApp/clClientProperty.h"

class clConfigInterface;

/**
 * @author vnd4kor
 * @version 1.0
 * @created 12-Mar-2015 10:20:45
 */
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_HDFirmwareInfo : public tuner::AarsApp::clClientProperty
{
private:
	clConfigInterface* m_poclConfigInterface;
public:
   clAars_HDFirmwareInfo();
   virtual ~clAars_HDFirmwareInfo();

   /**
    *
    * @param poAarsHandler
    */
   clAars_HDFirmwareInfo(tuner::AarsApp::clAarsHandler* poAarsHandler,clConfigInterface* poclConfigInterface);

   void vGetHDFirmwareInfo();

   virtual void vOnServiceAvailable();

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);

};

#endif // !defined(clAars_HDFirmwareInfo_h)
