/************************************************************************
 * FILE:           clAars_GetConfigurationInfo.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_GetConfigurationInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "clAars_GetConfigurationInfo.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_GetConfigurationInfo.cpp.trc.h"
#endif


clAars_GetConfigurationInfo::clAars_GetConfigurationInfo():
m_u32CRC32(0)
{
}

clAars_GetConfigurationInfo::~clAars_GetConfigurationInfo(){

}

clAars_GetConfigurationInfo::clAars_GetConfigurationInfo(tuner::AarsApp::clAarsHandler* poAarsHandler):
		tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_GETCONFIGURATIONINFO, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){
	m_u32CRC32 = 0;
}

void clAars_GetConfigurationInfo::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMGetConfigurationInfoStatus oData;
   oMsg.vGetDataFromPayload(oData);
   m_sVersionInfo = oData.getVersionInfo();
   m_u32CRC32 = oData.getCRC32();
   ETG_TRACE_USR4(("clAars_GetConfigurationInfo::vStatus"));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewGetConfigurationInfoStatus(m_sVersionInfo,m_u32CRC32);
}

void clAars_GetConfigurationInfo::vGetConfigurationinfo()
{
   clCMGetConfigurationInfoGet oData;
   vGet(oData);
}
