/************************************************************************
 * FILE:          clAars_DemodulationSwitch.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_DemodulationSwitch
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
     
				
 *************************************************************************/

#ifndef CLAARS_DEMODULATIONSWITCH_H
#define CLAARS_DEMODULATIONSWITCH_H

#include "AarsApp/clClientProperty.h"
class tun_ActualData;
class clAars_ATPresetList_XX;
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_DemodulationSwitch : public tuner::AarsApp::clClientProperty
{

public:
	clAars_DemodulationSwitch();
   virtual ~clAars_DemodulationSwitch();
   /**
    *
    * @param poAarsHandler
    */
   clAars_DemodulationSwitch(tuner::AarsApp::clAarsHandler* poAarsHandler,tun_ActualData* potun_ActualData);
   
   void vSetDemodulationSwitch(unsigned char u8DemodulationSwitch);
   void vGetDemodulationSwitch();
   unsigned char u8GetAarsDemodulationSwitch();
   void vSet_clAars_ATPresetList_XXPtr(clAars_ATPresetList_XX* poclAars_ATPresetList_XX);

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
   virtual void vError(tunerVector<unsigned char> bitStream);
private:
	unsigned char m_u8DemodulationSwitch; 
	clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
	tun_ActualData* m_potun_ActualData;
	tVoid vSendGetPresetList();
};

#endif // CLAARS_DEMODULATIONSWITCH_H
