/************************************************************************
 * FILE:           clAars_DemodulationSwitch.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_DemodulationSwitch
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  16-Jan-2015       
				
 *************************************************************************/

#include "tun_ActualData.h"
#include "clAars_ATPresetList_XX.h"
#include "clAars_DemodulationSwitch.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_DemodulationSwitch.cpp.trc.h"
#endif


clAars_DemodulationSwitch::clAars_DemodulationSwitch():m_u8DemodulationSwitch(0){
	m_poclAars_ATPresetList_XX = nullptr;
	m_potun_ActualData = nullptr;
}



clAars_DemodulationSwitch::~clAars_DemodulationSwitch(){
	m_poclAars_ATPresetList_XX = nullptr;
	m_potun_ActualData = nullptr;
	m_u8DemodulationSwitch = 0;
}





clAars_DemodulationSwitch::clAars_DemodulationSwitch(tuner::AarsApp::clAarsHandler* poAarsHandler, tun_ActualData* potun_ActualData):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_DEMODULATIONSWITCH, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){
  m_u8DemodulationSwitch = 0;
  m_potun_ActualData = potun_ActualData;
  m_poclAars_ATPresetList_XX = nullptr;
}
void clAars_DemodulationSwitch::vSet_clAars_ATPresetList_XXPtr(clAars_ATPresetList_XX* poclAars_ATPresetList_XX)
{
	m_poclAars_ATPresetList_XX = poclAars_ATPresetList_XX;
}

void clAars_DemodulationSwitch::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMDemodulationSwitchStatus oData;
   oMsg.vGetDataFromPayload(oData);
   clTmcTuner_TMCTunerControl oTunerControl;
   if((m_u8DemodulationSwitch & 0x06) != (oData.DemodulationSwitches & 0x06)) // HD switch enabled/disabled
   {
	   oTunerControl.vOnCM_ChangeOfSurveilledStationsStatus();
   }
   m_u8DemodulationSwitch = oData.DemodulationSwitches;
   ETG_TRACE_USR4(("clAars_DemodulationSwitch::vStatus: %d",m_u8DemodulationSwitch ));
   oTunerControl.vOnNewDemodulationStatus(m_u8DemodulationSwitch);
   vSendGetPresetList();
}

tVoid clAars_DemodulationSwitch::vSendGetPresetList()
{
	if((m_potun_ActualData != nullptr) && (m_poclAars_ATPresetList_XX != nullptr))
	{
		unsigned short u16ActiveADRPresetListID = m_potun_ActualData->m_otun_Data_Station.u16GetStaticListID();
		m_poclAars_ATPresetList_XX->vGetPresetList(u16ActiveADRPresetListID);
	}

}


void clAars_DemodulationSwitch::vSetDemodulationSwitch(unsigned char u8DemodulationSwitch)
{
   ETG_TRACE_USR4(("clAars_DemodulationSwitch::vSetDemodulationSwitch: %d", u8DemodulationSwitch ));
   clCMDemodulationSwitchSetGet oData;
   oData.DemodulationSwitches = u8DemodulationSwitch;
   vSetGet(oData);
}

void clAars_DemodulationSwitch::vGetDemodulationSwitch()
{
   ETG_TRACE_USR4(("clAars_DemodulationSwitch::vGetDemodulationSwitch: "));
   clCMDemodulationSwitchGet oData;
   vGet(oData);
}

unsigned char clAars_DemodulationSwitch::u8GetAarsDemodulationSwitch()
{
   return m_u8DemodulationSwitch;
}
/*Fix for RTC bug 99115 */
void clAars_DemodulationSwitch::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_DemodulationSwitch::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnNewDemodulationError(oData);
}