/************************************************************************
 * FILE:           clAars_DRMLogicalFrame.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_DRMLogicalFrame
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   14-Jan-2015         pad1cob
				
 *************************************************************************/



#include "clAars_DRMLogicalFrame.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "drmPlayer/drmPlayerInterface.h"
#include "tuner_trace.h"
#include "Aars/clAars_DRMAudioStreamDecoderStatus.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_DRMLogicalFrame.cpp.trc.h"
#endif

using namespace tuner::drm;

clAars_DRMLogicalFrame::clAars_DRMLogicalFrame(){

   m_poDRMAudioStreamDecoderStatus = 0;

}



clAars_DRMLogicalFrame::~clAars_DRMLogicalFrame(){

   m_poDRMAudioStreamDecoderStatus = 0;
}


clAars_DRMLogicalFrame::clAars_DRMLogicalFrame(tuner::AarsApp::clAarsHandler* poAarsHandler, clAars_DRMAudioStreamDecoderStatus *poDRMAudioStreamDecoderStatus):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_DRMLOGICALFRAME, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

   m_poDRMAudioStreamDecoderStatus = poDRMAudioStreamDecoderStatus;
}


void clAars_DRMLogicalFrame::vStatus(tunerVector<unsigned char> &bitStream){
   ETG_TRACE_USR4(("clAars_DRMLogicalFrame::vStatus:" ));

   clADRInMsg oMsg(bitStream);
   clCMDRMAudioLogicalFrameStatus* m_poFrame = new clCMDRMAudioLogicalFrameStatus();
   
	if(m_poFrame == NULL || m_poDRMAudioStreamDecoderStatus == NULL)
	{
		delete m_poFrame;
		return; //lint !e429
	}

   oMsg.vGetDataFromPayload(*m_poFrame);

   ETG_TRACE_USR4(("clAars_DRMLogicalFrame::m_poFrame->FrameData.size() :%d", m_poFrame->FrameData.size()));
   ETG_TRACE_USR4(("clAars_DRMLogicalFrame::m_poFrame->LenAudioInfoEntity: %d", m_poFrame->LenAudioInfoEntity));
   ETG_TRACE_USR4(("clAars_DRMLogicalFrame::m_poFrame->NonReliabilityIndication: %d", m_poFrame->NonReliabilityIndication.enType ));

	if (m_poFrame->LenAudioInfoEntity != 0)
	{
		drmPlayerInterface* player = drmPlayerInterface::getInstance();
		player->vOnNewData(m_poFrame);
	   m_poDRMAudioStreamDecoderStatus->vUpdateDatatoAudioStreamDecoderStatus(m_poFrame);
	}
	else
	{
		ETG_TRACE_USR4(("clAars_DRMLogicalFrame:: m_poFrame->LenAudioInfoEntity is 0"));
	}

}//lint !e429

