/************************************************************************
 * FILE:           clAars_CM_StationListRelease.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_StationListRelease
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/



#include "clAars_CM_StationListRelease.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
/*****************************************************************************

******************************************************************************/

clAars_CM_StationListRelease::clAars_CM_StationListRelease(){

}

/*****************************************************************************

******************************************************************************/

clAars_CM_StationListRelease::~clAars_CM_StationListRelease(){

}
/*****************************************************************************

******************************************************************************/

clAars_CM_StationListRelease::clAars_CM_StationListRelease(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_STATIONLISTRELEASE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){

}

/*****************************************************************************

******************************************************************************/
void clAars_CM_StationListRelease::vReleaseStationList(unsigned char  u8List)
{
	clCMStationListReleaseSet oData;
	oData.setListId(u8List);
	vSet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_StationListRelease::vStatus(tunerVector<unsigned char> &/*bitStream*/)
{
}
