/************************************************************************
 * FILE:           clAars_CM_StationListConfig.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_CM_StationListConfig
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/



#ifndef CLAARS_CM_STATIONLISTCONFIG
#define CLAARS_CM_STATIONLISTCONFIG

#include "AarsApp/clClientMethod.h"
class clConfigInterface;
class tun_MsgToHMI;
class clAars_CM_StationsList;
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_CM_StationListConfig : public tuner::AarsApp::clClientMethod
{

public:
   virtual ~clAars_CM_StationListConfig();
   clAars_CM_StationListConfig(tuner::AarsApp::clAarsHandler* poAarsHandler,clConfigInterface* poclConfigInterface,clAars_CM_StationsList* poclAars_CM_StationsList);
   void vSendStationListConfig(clCMStationListConfigStartResult oData);
   clCMEnum_Sorting::enSorting enFindSortingCriteria(clCMEnum_Sorting::enSorting oclCMEnum_Sorting);
   void vSettun_MsgToHMIptr(tun_MsgToHMI* potun_MsgToHMI);

protected:
   virtual void vMethodResult(tunerVector<unsigned char> bitStream);
private:
   clConfigInterface* m_poclConfigInterface;
   tun_MsgToHMI* m_potun_MsgToHMI;
   clAars_CM_StationsList* m_poclAars_CM_StationsList;

   bool bIsStationListUpdateRequired(unsigned short u16NumberOfStations);

};

#endif
