/************************************************************************
 * FILE:           clAars_ATPresetListSetActive.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATPresetListSetActive
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "clAars_CM_StationListConfig.h"
#include "clAars_CM_StationsList.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "ADRMsg/types/clCMEnumTypes.h"
#include "kdsconfig/clConfigInterface.h"
#include "tun_MsgToHMI.h"
#include "tun_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clAars_CM_StationListConfig.cpp.trc.h"
#endif

/*****************************************************************************

******************************************************************************/
clAars_CM_StationListConfig::~clAars_CM_StationListConfig(){

	m_poclAars_CM_StationsList=0;
	m_poclConfigInterface=0;
	m_potun_MsgToHMI=0;
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_StationListConfig::vSettun_MsgToHMIptr(tun_MsgToHMI* potun_MsgToHMI)
{
	m_potun_MsgToHMI=potun_MsgToHMI;
}
/*****************************************************************************

******************************************************************************/
clAars_CM_StationListConfig::clAars_CM_StationListConfig(tuner::AarsApp::clAarsHandler* poAarsHandler,clConfigInterface* poclConfigInterface,clAars_CM_StationsList* poclAars_CM_StationsList):
  tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_STATIONLISTCONFIG, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){
	m_potun_MsgToHMI=NULL;
	m_poclConfigInterface=poclConfigInterface;
	m_poclAars_CM_StationsList=poclAars_CM_StationsList;
	
}
/*****************************************************************************

******************************************************************************/
clCMEnum_Sorting::enSorting clAars_CM_StationListConfig::enFindSortingCriteria(clCMEnum_Sorting::enSorting oclCMEnum_Sorting)
{
	if((clCMEnum_Sorting::FIELDSTRENGTH_ASCENDING!=oclCMEnum_Sorting)&&
			(clCMEnum_Sorting::FIELDSTRENGTH_DESCENDING!=oclCMEnum_Sorting)&&
			(clCMEnum_Sorting::FREQUENCY_ASCENDING!=oclCMEnum_Sorting)&&
			(clCMEnum_Sorting::FREQUENCY_DESCENDING!=oclCMEnum_Sorting))
	{
		/*If RDS switch is off then any sorting criteria related
		 to RDS will be replaced with default sorting criteria frequency ascending*/
		if(m_potun_MsgToHMI == NULL)
		{
			NORMAL_M_ASSERT(m_potun_MsgToHMI != NULL);
			return oclCMEnum_Sorting;
		}
		if(0==m_potun_MsgToHMI->u8GetRDSSwitchStatus())
		{
			oclCMEnum_Sorting=clCMEnum_Sorting::FREQUENCY_ASCENDING;
		}
		/* If RDS switch is on and PI ignore is TRUE then any sorting criteria w.r.t PI will be replaced default sorting criteria frequency ascending*/
		else if((m_poclConfigInterface->u32GetConfigData("PIIgnore"))&& ((clCMEnum_Sorting::PI_ASCENDING==oclCMEnum_Sorting)||(clCMEnum_Sorting::PI_DESCENDING==oclCMEnum_Sorting)))
		{
			oclCMEnum_Sorting=clCMEnum_Sorting::FREQUENCY_ASCENDING;
		}
	}
	return oclCMEnum_Sorting;
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_StationListConfig::vSendStationListConfig(clCMStationListConfigStartResult oData){

	oData.Sorting.enType=enFindSortingCriteria(oData.Sorting.enType);
	vMethodStartResult(oData);
}

/*****************************************************************************

******************************************************************************/
void clAars_CM_StationListConfig::vMethodResult(tunerVector<unsigned char> bitStream){
	clADRInMsg oMsg(bitStream);
	clCMStationListConfigResult oData;
	oMsg.vGetDataFromPayload(oData);

	if(oData.ListId == 0x06)
	{
		m_poclAars_CM_StationsList->vGetStationList(oData.ListId);
	}
	else
	{
		if(bIsStationListUpdateRequired(oData.NumberOfStations))
		{
			m_poclAars_CM_StationsList->vGetStationList(oData.ListId);
		}

		clTmcTuner_TMCTunerControl oTunerControl;
		oTunerControl.vOnCM_StationListConfigResult(oData.ListId,(unsigned char)(oData.NumberOfStations));
	}
}

/*****************************************************************************

******************************************************************************/
bool clAars_CM_StationListConfig::bIsStationListUpdateRequired(unsigned short u16NumberOfStations)
{
	return u16NumberOfStations != 0 ? true : false;
}


