/************************************************************************
 * FILE:           clAars_CM_SetUserOptions.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_CM_SetUserOptions
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author      aso9kor                 | Modification


 *************************************************************************/

#ifndef clAars_CM_SetUserOptions_h
#define clAars_CM_SetUserOptions_h

#include "AarsApp/clClientProperty.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class tun_MsgToADR;
class clAars_CM_SetUserOptions : public tuner::AarsApp::clClientProperty
{

public:
   clAars_CM_SetUserOptions();
   virtual ~clAars_CM_SetUserOptions();

   /**
    *
    * @param poAarsHandler
    */
   clAars_CM_SetUserOptions(tuner::AarsApp::clAarsHandler* poAarsHandler);
   void vSetUser(unsigned char u8UserId, unsigned int u32UserOptions);
   void vSet_tun_MsgToADR_Ptr(tun_MsgToADR* potun_MsgToADR);
   tU8 u8GetCurrentUserID();
   bool bStartup;

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
   virtual void vError(tunerVector<unsigned char> bitStream);
private:
	tun_MsgToADR* m_potun_MsgToADR;
};

#endif // clAars_CM_SetUserOptions_h
