/************************************************************************
 * FILE:           clAars_CM_SetUserOptions.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_SetUserOptions
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author       aso9kor            | Modification


 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_CM_SetUserOptions.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_MsgToADR.h"
#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_SetUserOptions.cpp.trc.h"
#endif

clAars_CM_SetUserOptions::clAars_CM_SetUserOptions()
{
	m_potun_MsgToADR = NULL;
	bStartup = true;
}
clAars_CM_SetUserOptions::~clAars_CM_SetUserOptions()
{
	m_potun_MsgToADR = NULL;
	bStartup = true;
}

clAars_CM_SetUserOptions::clAars_CM_SetUserOptions(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_SetUserOptions, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{
	m_potun_MsgToADR = NULL;
	bStartup = true;
}

tVoid clAars_CM_SetUserOptions::vSet_tun_MsgToADR_Ptr(tun_MsgToADR* potun_MsgToADR)
{
	if(potun_MsgToADR != NULL)
	{
		m_potun_MsgToADR = potun_MsgToADR;
	}
}


void clAars_CM_SetUserOptions::vSetUser(unsigned char u8UserId, unsigned int u32UserOptions)
{
    ETG_TRACE_USR4(("clAars_CM_SetUserOptions::vSetUser: UserId = %d, UserOptions = %d",u8UserId,u32UserOptions));
    clCMSetUserOptionsSet oData;
    oData.setUserId(u8UserId);
    oData.setUserOptions(u32UserOptions);
    vSetGet(oData);

}

void clAars_CM_SetUserOptions::vStatus(tunerVector<unsigned char> &bitStream)
{
	if(m_potun_MsgToADR != NULL)
	{
   clADRInMsg oMsg(bitStream);
   clCMSetUserOptionsStatus oData;
   oMsg.vGetDataFromPayload(oData);
   unsigned char u8UserId = oData.UserId;
   unsigned int u32UserOptions = oData.UserOptions;

	   ETG_TRACE_USR4(("clAars_CM_SetUserOptions::vStatus: u8UserId  = %d, u32UserOptions = %d", u8UserId, u32UserOptions ));
   clTmcTuner_TMCTunerControl oTunerControl;
	   if(bStartup)
	   {
		   ETG_TRACE_USR4(("clAars_CM_SetUserOptions::vStatus for Get userID, u8UserId : %d", u8UserId));
		   m_potun_MsgToADR->m_u8CurrentUserId = u8UserId;
		   m_potun_MsgToADR->vStartupSetUserReq();
		   bStartup = false;
	   }
	   else
	   {
		   if(m_potun_MsgToADR->bGetNotificationSentStatus())
		   {
				m_potun_MsgToADR->m_u8CurrentUserId = u8UserId;
   oTunerControl.vOnNewCMSetUserOptionsStatus(oData.UserId,oData.UserOptions);
		   }
		   else
		   {
				m_potun_MsgToADR->vDoNotification();
		   }
	   }
	}
}

void clAars_CM_SetUserOptions::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_CM_SetUserOptions::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnCM_SetUserOptionsError(oData);
}
tU8 clAars_CM_SetUserOptions::u8GetCurrentUserID()
{
	if(m_potun_MsgToADR != NULL)
	{
		return m_potun_MsgToADR->m_u8CurrentUserId;
	}
	else
	{
		return 0xFF;
	}
}
