/*
 * clAarsCMPresetListContentUpdate.cpp
 *
 *  Created on: 04-May-2018
 *      Author: aso9kor
 */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_CM_PresetListContentUpdate.h"
#include "AarsApp/clAarsHandler.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_MsgToADR.h"
#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_PresetListContentUpdate.cpp.trc.h"
#endif

clAars_CM_PresetListContentUpdate::clAars_CM_PresetListContentUpdate()
{


}

clAars_CM_PresetListContentUpdate::~clAars_CM_PresetListContentUpdate()
{

}

clAars_CM_PresetListContentUpdate::clAars_CM_PresetListContentUpdate(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_PRESETLISTCONTENTUPDATE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL)
{
}

void clAars_CM_PresetListContentUpdate::vPresetListContentUpdateStartResult(tU8 u8userID,tU8 u8TypeOfParameterSet, tU8 u8NumberOfPresetsToUpdate, std::vector<clCMPresetListContentUpdate_Data> &oclCMPresetListContentUpdate_Data_list)
{
	clCMPresetListContentUpdateStartResult oData;
	oData.vsetNumberOfPresetsToUpdate(u8userID,u8TypeOfParameterSet,u8NumberOfPresetsToUpdate);
	for(tU8 i = 0; i < oclCMPresetListContentUpdate_Data_list.size(); i++)
	{
		oData.vPopulate(oclCMPresetListContentUpdate_Data_list.at(i));
	}
	vMethodStartResult(oData);
}


/*****************************************************************************

******************************************************************************/
void clAars_CM_PresetListContentUpdate::vMethodResult(tunerVector<unsigned char> bitStream){
   clADRInMsg oMsg(bitStream);
   clCMPresetListContentUpdateResult oData;
   oMsg.vGetDataFromPayload(oData);
   tU8 u8Result = oData.getu8Result();
   ETG_TRACE_USR4(("clAars_CM_PresetListContentUpdate:: vMethodResult  = %d", u8Result));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnPresetListContentUpdateResult(u8Result);
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_PresetListContentUpdate::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_CM_PresetListContentUpdate::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnCM_PresetListContentUpdateError();
}
