/************************************************************************
 * FILE:           clAars_CM_EvaluationParameter.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_CM_EvaluationParameter
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#ifndef clAars_CM_EvaluationParameter_h
#define clAars_CM_EvaluationParameter_h

#include "AarsApp/clClientProperty.h"
#define PHYSICAL_TUNER_INSTANCES 4 

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_CM_EvaluationParameter : public tuner::AarsApp::clClientProperty
{

public:
   clAars_CM_EvaluationParameter();
   virtual ~clAars_CM_EvaluationParameter();

   /**
    *
    * @param poAarsHandler
    */
   clAars_CM_EvaluationParameter(tuner::AarsApp::clAarsHandler* poAarsHandler);

   void vSetHDSectionParameter(unsigned short u16ParameterID, char s8ParameterValue);
   void vSetTunerband(unsigned short u16ParamterID, char s8ParameterValue);
   void vGetHDSectionParameter(unsigned short u16ParamterID);
   unsigned char pu8GetPhysicalTunerValue(unsigned short iTunerID);
   virtual void vOnServiceAvailable();

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
private:
   unsigned char m_u8PhysicalTuner[PHYSICAL_TUNER_INSTANCES];

};

#endif // clAars_CM_EvaluationParameter_h
