/************************************************************************
 * FILE:           clAars_DRMAudioStreamDecoderStatus.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_DRMCurrentRadiotext
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
				
 *************************************************************************/


#include "clAars_CM_DRMCurrentRadiotext.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"

#include "tun_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_DRVADRIF
#include "trcGenProj/Header/clAars_CM_DRMCurrentRadiotext.cpp.trc.h"
#endif

clAars_CM_DRMCurrentRadiotext::clAars_CM_DRMCurrentRadiotext(){

}



clAars_CM_DRMCurrentRadiotext::~clAars_CM_DRMCurrentRadiotext(){

}


clAars_CM_DRMCurrentRadiotext::clAars_CM_DRMCurrentRadiotext(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_DRMCURRENTRADIOTEXT, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}
void clAars_CM_DRMCurrentRadiotext::vStatus(tunerVector<unsigned char> &bitStream){
	   clADRInMsg oMsg(bitStream);
	   clCMDRMCurrentRadiotextStatus oData;
	   oMsg.vGetDataFromPayload(oData);
	   clTmcTuner_TMCTunerControl oTunerControl;
	   oTunerControl.vOnCM_DRMCurrentRadiotextStatus(oData.getRadiotextBytes());

}

void clAars_CM_DRMCurrentRadiotext::vGetDRMCurrentRadiotext(){
	   clCMDRMCurrentRadiotextGet oData;
	   vGet(oData);
}

