/************************************************************************
 * FILE:           clAars_CM_DARCGetData.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_DARCGetData
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
					   auj1kor
				
 *************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_CM_DARCGetData.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"


clAars_CM_DARCGetData::clAars_CM_DARCGetData()
{
}



clAars_CM_DARCGetData::~clAars_CM_DARCGetData()
{
}


clAars_CM_DARCGetData::clAars_CM_DARCGetData(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_DARC_GETDATA, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL)
{
}

void clAars_CM_DARCGetData::vStatus(tunerVector<unsigned char> &bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMDARCGetDataStatus oData;
    oMsg.vGetDataFromPayload(oData);
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnCM_DARCDataStatus(oData);
}

