/************************************************************************
 * FILE:           clAars_CM_ChangeOfSurveilledStations.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_ChangeOfSurveilledStations
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Jul 1, 2015		   rrb1kor
				
 *************************************************************************/



#include "Aars/clAars_CM_Commit.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "ADRMsg/ADRMsg_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h" 
#include "tun_trace.h"
//#include "tun_main.h"
#include "tun_MsgToADR.h"
//#include "tun_Manager.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_Commit.cpp.trc.h"
#endif

/*****************************************************************************

******************************************************************************/
clAars_CM_Commit::~clAars_CM_Commit() {
	//m_potu_Manager=0;
	m_potun_MsgToADR=0;
}
/*****************************************************************************

******************************************************************************/
clAars_CM_Commit::clAars_CM_Commit(tuner::AarsApp::clAarsHandler* poAarsHandler):
 tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_COMMIT, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){
	m_potun_MsgToADR=static_cast<tun_MsgToADR*>(poAarsHandler);
	//m_potuner_tclApp=potuner_tclApp;

}
/*****************************************************************************

******************************************************************************/
void clAars_CM_Commit::vSendCommitMsg()
{
	clCMCommitStartResult oData;
	vMethodStartResult(oData);

}

/*****************************************************************************

******************************************************************************/
void clAars_CM_Commit::vMethodResult(tunerVector<unsigned char> /*bitStream*/){
    ETG_TRACE_USR1(("CCR.ENDING.LASTMODE_DATA:clAars_CM_Commit::vMethodResult"));
	ETG_TRACE_USR4(("clAars_CM_Commit::vMethodResult"));
	/** NCG3D-10402 and NCG3D-8305 tuner shut down handled in main thread */
	//if(AMT_C_U32_STATE_NORMAL!=m_potu_Manager->u8GetTunerSystemState())
	{
		//m_potuner_tclApp->vTunerShutDownProcess();
		m_potun_MsgToADR->vSetLandscapeRequested(false);
	}
}
