/************************************************************************
 * FILE:          clAars_CM_EvaluationParameter.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_EvaluationParameter
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "clAars_CM_CalibrationData.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"
#include "interface/clTmcTuner_TMCTunerControl.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_CalibrationData.cpp.trc.h"
#endif


clAars_CM_CalibrationData::clAars_CM_CalibrationData(){

}



clAars_CM_CalibrationData::~clAars_CM_CalibrationData(){

}





clAars_CM_CalibrationData::clAars_CM_CalibrationData(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_CALIBRATIONDATA, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}

void clAars_CM_CalibrationData::vStatus(tunerVector<unsigned char> &bitStream)
{
   clADRInMsg oMsg(bitStream);
   clCMCalibrationDataStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_CM_CalibrationData::vStatus: FM1: 0x%x, FM2: 0x%x, FM3: 0x%x, FM4: =0x%x", oData.calival_FM1, oData.calival_FM2, oData.calival_FM3, oData.calival_FM4 ));
   ETG_TRACE_USR4(("clAars_CM_CalibrationData::vStatus: MW1: 0x%x, MW2: 0x%x, MW3: 0x%x, MW4: =0x%x", oData.calival_MW1, oData.calival_MW2, oData.calival_MW3, oData.calival_MW4 ));
   ETG_TRACE_USR4(("clAars_CM_CalibrationData::vStatus: SW1: 0x%x, SW2: 0x%x, SW3: 0x%x, SW4: =0x%x", oData.calival_SW1, oData.calival_SW2, oData.calival_SW3, oData.calival_SW4 ));
   ETG_TRACE_USR4(("clAars_CM_CalibrationData::vStatus: WB1: 0x%x, WB2: 0x%x, WB3: 0x%x, WB4: =0x%x", oData.calival_WB1, oData.calival_WB2, oData.calival_WB3, oData.calival_WB4 ));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnCalibrationStatus(oData);
}

void clAars_CM_CalibrationData::vGetCalibrationData()
{
    ETG_TRACE_USR4(("clAars_CM_CalibrationData::vGetCalibrationData: "));
    clCMCalibrationDataGet oData;
    vGet(oData);
}
