/************************************************************************
 * FILE:          clAars_CM_AdditionalVersionInfo.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_AdditionalVersionInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 


#include "clAars_CM_AdditionalVersionInfo.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"



#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_AdditionalVersionInfo.cpp.trc.h"
#endif


clAars_CM_AdditionalVersionInfo::clAars_CM_AdditionalVersionInfo(){
}



clAars_CM_AdditionalVersionInfo::~clAars_CM_AdditionalVersionInfo(){
}





clAars_CM_AdditionalVersionInfo::clAars_CM_AdditionalVersionInfo(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ADDITIONALVERSIONINFO, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}


void clAars_CM_AdditionalVersionInfo::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMAdditionalVersionInfoStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_CM_AdditionalVersionInfo"));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewAdditionalVersionInfoStatus(oData.getFirstVersionDigit(),oData.getSecondVersionDigit(),oData.getThirdVersionDigit());
}



void clAars_CM_AdditionalVersionInfo::vGetAdditionalVersionInfo(){
   clCMAdditionalVersionInfoGet oData;
   vGet(oData);
}


