/************************************************************************
 * FILE:          clAars_AudioSource.h 
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_AudioSource
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   14-Jan-2015         pad1cob
				
 *************************************************************************/
 


#if !defined(EA_3CDF9CDE_EAA2_4087_8957_A34CC64B5D05__INCLUDED_)
#define EA_3CDF9CDE_EAA2_4087_8957_A34CC64B5D05__INCLUDED_

#include "AarsApp/clClientProperty.h"
class tun_ActualData;
class tun_Config;
class tun_MsgToADR;
class clConfigInterface;
class tun_MsgFromHMI;
class tuner_tclApp;
class clAars_CM_UpdateLandscape;
/**
 * @author pad1cob
 * @version 1.0
 * @created 14-Jan-2015 10:20:45
 */
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_AudioSource : public tuner::AarsApp::clClientProperty
{

public:
   clAars_AudioSource();
   virtual ~clAars_AudioSource();

   /**
    *
    * @param poAarsHandler
    */
   clAars_AudioSource(tuner_tclApp* poGWMain, tuner::AarsApp::clAarsHandler* poAarsHandler,tun_ActualData* potun_ActualData,tun_Config* potun_Config,tun_MsgToADR* potun_MsgToADR,clConfigInterface* poclConfigInterface, clAars_CM_UpdateLandscape* poclAars_CM_UpdateLandscape);

   void vSetAudioSource(clCMEnum_AudioSource::enAudioSource audioSource);
   void vSettun_MsgFromHMIImpl(tun_MsgFromHMI* potun_MsgFromHMI);

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
private:
   tuner_tclApp*  m_poGWMain;
   tun_ActualData*	m_potun_ActualData;
   tun_Config* m_potun_Config;
   tun_MsgToADR* m_potun_MsgToAdr;
   clConfigInterface* m_poclConfigInterface;
   tun_MsgFromHMI* m_potun_MsgFromHMI;
   clAars_CM_UpdateLandscape* m_poclAars_CM_UpdateLandscape;
};

#endif // !defined(EA_3CDF9CDE_EAA2_4087_8957_A34CC64B5D04__INCLUDED_)
