/************************************************************************
 * FILE:        clAars_AtPiSearch.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clAars_AtPiSearch method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   15-Apr-2015        vnd4kor
				
 *************************************************************************/

#ifndef clAars_AtPiSearch_H
#define clAars_AtPiSearch_H

#include "AarsApp/clClientProperty.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_AtPiSearch : public tuner::AarsApp::clClientProperty
{

public:
	clAars_AtPiSearch();
   virtual ~clAars_AtPiSearch();

   /**
    *
    * @param poAarsHandler
    */
   clAars_AtPiSearch(tuner::AarsApp::clAarsHandler* poAarsHandler);
   
   unsigned char m_u8PiSearchState;
   unsigned short m_u16PICode;
   
   void vSendAtPiSearchStatus(unsigned char u8PiSearchStatus,unsigned short u16PI);
   void vOnNewAtStationPICode(unsigned short u16AtStationInfoPICode);

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
private:
	bool bIsPiSearchStateLost();
	bool bIsEqualAtStationInfoPIandAtPiSearchPI(unsigned short u16AtStationInfoPICode);
};

#endif // clAars_AtPiSearch_H
