/************************************************************************
 * FILE:           clAars_AtPiSearch.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_AtPiSearch
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   16-Jan-2015        vnd4kor
 *************************************************************************/



#include "clAars_AtPiSearch.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_AtPiSearch.cpp.trc.h"
#endif


clAars_AtPiSearch::clAars_AtPiSearch(){
	m_u8PiSearchState = (tU8)clCMEnum_PiSearchStatus::Pi_search_ended_and_PI_found;
	m_u16PICode = 0;
}

clAars_AtPiSearch::~clAars_AtPiSearch(){

}

clAars_AtPiSearch::clAars_AtPiSearch(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATPISEARCH, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){
	m_u8PiSearchState = (unsigned char)clCMEnum_PiSearchStatus::Pi_search_ended_and_PI_found;
	m_u16PICode = 0;
}

void clAars_AtPiSearch::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMAtPiSearchStatus oData;
   oMsg.vGetDataFromPayload(oData);
   vSendAtPiSearchStatus((unsigned char)oData.PiSearchStatus.enType,oData.PI);
}


void clAars_AtPiSearch::vOnNewAtStationPICode(unsigned short u16AtStationInfoPICode)
{
	if(bIsPiSearchStateLost())
	{
		if(bIsEqualAtStationInfoPIandAtPiSearchPI(u16AtStationInfoPICode))
		{
			m_u8PiSearchState = (tU8)clCMEnum_PiSearchStatus::Pi_search_ended_and_PI_found;
			vSendAtPiSearchStatus(m_u8PiSearchState,m_u16PICode);
		}
	}
}


void clAars_AtPiSearch::vSendAtPiSearchStatus(unsigned char u8PiSearchState,unsigned short u16PICode)
{
   m_u8PiSearchState = u8PiSearchState;
   m_u16PICode = u16PICode;

   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewAtPiSearchStatus(m_u8PiSearchState);
   ETG_TRACE_USR4(("clAars_AtPiSearch::vStatus: PISearchStatus = %d, PI = 0x%4x",m_u8PiSearchState,m_u16PICode ));
}

bool clAars_AtPiSearch::bIsEqualAtStationInfoPIandAtPiSearchPI(unsigned short u16AtStationInfoPICode)
{
	return (u16AtStationInfoPICode == m_u16PICode) ? true : false;
}

bool clAars_AtPiSearch::bIsPiSearchStateLost()
{
	return (m_u8PiSearchState == (unsigned char)clCMEnum_PiSearchStatus::Pi_search_ended_and_PI_not_found) ? true : false;
}

