/************************************************************************
 * FILE:           clAars_ATTunerState.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_ATTunerState
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#ifndef clAars_ATTunerState_h
#define clAars_ATTunerState_h

#include "AarsApp/clClientProperty.h"
#include "tun_MsgToHMI.h"
#include "clAars_AtPiSearch.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"
#include "AMFMTuner/clTmcTuner_Method_S_AUDIO_FG_BG_NEW.h"
#include "ADRMsg/ADRMsg_if.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

namespace Mute
{
	namespace MuteHandling
	{
		class clMuteImpl;
	}
}

class clAars_ATTunerState : public tuner::AarsApp::clClientProperty
{

public:
   virtual ~clAars_ATTunerState();

   /**
    *
    * @param poAarsHandler
    */
   clAars_ATTunerState(tuner::AarsApp::clAarsHandler* poAarsHandler, clAars_AtPiSearch* m_poclAars_AtPiSearch,
		   tun_MsgToHMI* m_potun_MsgToHMI,
		   clTmcTuner_Method_S_AUDIO_FG_BG_NEW* m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW);

   
   void vClearStates();

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);

private:
   clAars_AtPiSearch* m_poAarsAtPiSearch;
   tun_MsgToHMI*      m_poTunMsgToHMI;
   Mute::MuteHandling::clMuteImpl*    m_poMuteImpl;
   clTmcTuner_Method_S_AUDIO_FG_BG_NEW* m_poMethod_S_AUDIO_FG_BG_NEW;

   void vPrintTestModeData( clCMATTunerStateStatus *oData );
   bool bIsTuningActionRunning();
   bool bIsTuningActionAborted(unsigned short u16FktId);
   bool bIsDemuteRequired(Mute::MuteHandling::enMuteTuningAction action);
   void vHandleFGBGMethodResult();
   bool bIsTuningActionAudioSource();
   
   unsigned short m_u16TuningFktId;
   unsigned char m_u8TuningState;
   bool bIsMixedPresetRecall;

};

#endif // CLAARS_DEMODULATIONSWITCH_H
