/************************************************************************
 * FILE:         clAars_ATPresetList_XX.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clAars_ATPresetList_XX method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_ATPresetList_XX.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_MsgToADR.h"
#include "tun_Config.h"
#include "tun_MsgToHMI.h"
#include "conversionTable/midwTunerToAdr3Map.h"

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATPresetList_XX.cpp.trc.h"
#endif

/*****************************************************************************
* Destructor
******************************************************************************/
clAars_ATPresetList_XX::~clAars_ATPresetList_XX(){
	
	m_potun_Config = 0;
	m_potun_MsgToHMI = NULL;
}
/*****************************************************************************
* Constructor
******************************************************************************/
clAars_ATPresetList_XX::clAars_ATPresetList_XX(tuner::AarsApp::clAarsHandler* poAarsHandler,tun_Config* potun_Config):
tuner::AarsApp::clClientProperty(poAarsHandler,ADR_MSG_FID_CM_ATPRESETLIST_00,ADR_MSG_FID_CM_ATPRESETLIST_31,ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{
	m_potun_Config=potun_Config;
	m_potun_MsgToHMI = NULL;
}

/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI )
{
	if( potun_MsgToHMI != NULL )
	{  
		m_potun_MsgToHMI = potun_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potun_MsgToHMI != NULL );
	}
}

/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vGetPresetList(unsigned short U16List){
	clCMATPresetList_XX oData;
	oData.Pos.x=0;
	oData.Pos.y=enCM_PresetListPosY_selectAll;
	clClientProperty::setu16FunctionID(U16List);
	vGet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   	unsigned int NumberOfPresets = iGetNumberOfPresetsPerBank(oMsg.getHeader().getu16FunctionId());
	if(NumberOfPresets == 0)
	{
		ETG_TRACE_USR1(( "clAars_ATPresetList_XX::vSelectPresetListElement NumberOfPresets per bank = %d, do nothing",NumberOfPresets));
		return;
	}
	clCMATPresetList_XX oData((unsigned short)NumberOfPresets);
	oMsg.vGetDataFromPayload(oData);
   if(oData.Pos.x == CM_PresetListPosX_selectALL && oData.Pos.y == enCM_PresetListPosY_selectAll)
   {
	   clTmcTuner_TMCTunerControl oTunerControl;
	   oTunerControl.vOnCMATPresetList_XX_Status(oData,oMsg.getHeader().getu16FunctionId());
   }
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vSelectPresetListElement(unsigned short U16List,unsigned char u8ListElementID)
{
	unsigned int NumberOfPresets = iGetNumberOfPresetsPerBank(U16List);
	if((NumberOfPresets == 0) || (m_potun_MsgToHMI == NULL))
	{
		ETG_TRACE_USR1(( "clAars_ATPresetList_XX::vSelectPresetListElement NumberOfPresets per bank = %d, do nothing",NumberOfPresets));
		return;
	}
	m_potun_MsgToHMI->vSetRequestedPresetIndex(u8ListElementID);
    clCMATPresetList_XX oData((unsigned short)NumberOfPresets);
	oData.Pos.x=u8ListElementID;
	oData.Pos.y=enCM_PresetListPosY_Selected;
	oData.getData(u8ListElementID).PresetSelection=0x01; //set to 'active
	clClientProperty::setu16FunctionID(U16List);
	vSetGet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vDeleteSinglePresetElement(unsigned short U16List,unsigned char u8ListElementID)
{
	unsigned int NumberOfPresets = iGetNumberOfPresetsPerBank(U16List);
	if(NumberOfPresets == 0)
	{
		ETG_TRACE_USR1(( "clAars_ATPresetList_XX::vDeleteSinglePresetElement NumberOfPresets per bank = %d, do nothing",NumberOfPresets));
		return;
	}
	clCMATPresetList_XX oData((unsigned short)NumberOfPresets);
	oData.Pos.x=u8ListElementID;
	oData.Pos.y=enCM_PresetListPosY__Frequency;
	oData.getData(u8ListElementID).Frequency=0x00;
	clClientProperty::setu16FunctionID(U16List);
	vSet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vDeleteAllPreset(unsigned short U16List)
{
	unsigned int NumberOfPresets = iGetNumberOfPresetsPerBank(U16List);
	if(NumberOfPresets == 0)
	{
		ETG_TRACE_USR1(( "clAars_ATPresetList_XX::vDeleteAllPreset NumberOfPresets per bank = %d, do nothing",NumberOfPresets));
		return;
	}
    clCMATPresetList_XX oData((unsigned short)NumberOfPresets);
	oData.Pos.x=CM_PresetListPosX_selectALL;
	oData.Pos.y=enCM_PresetListPosY__Frequency;
	for (int PresetIndex=1;PresetIndex <= (int)NumberOfPresets;PresetIndex++)
	{
		oData.getData((unsigned short)PresetIndex).Frequency = 0x00;
	}
	clClientProperty::setu16FunctionID(U16List);
	vSet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetList_XX::vSendSpecialSaveListElement(unsigned short U16List,unsigned char u8ListElementID,unsigned short u16PI, unsigned int u32Frequency)
{
	unsigned int NumberOfPresets = iGetNumberOfPresetsPerBank(U16List);
	if(NumberOfPresets == 0)
	{
		ETG_TRACE_USR1(( "clAars_ATPresetList_XX::vSendSpecialSaveListElement NumberOfPresets per bank = %d, do nothing",NumberOfPresets));
		return;
	}
    clCMATPresetList_XX oData((unsigned short)NumberOfPresets);
	oData.Pos.x=u8ListElementID;
	oData.Pos.y=enCM_PresetListPosY_selectAll;
	oData.getData(u8ListElementID).Frequency = u32Frequency;
	oData.getData(u8ListElementID).PI=u16PI;
	clClientProperty::setu16FunctionID(U16List);
	vSetGet(oData);
}
/*****************************************************************************

******************************************************************************/
unsigned int clAars_ATPresetList_XX::iGetNumberOfPresetsPerBank(unsigned short U16List)
{
	unsigned int NumberOfPresets = 0;
    if(TUN_CONFIG_PRESETLIST_TYPE_MIXED== m_potun_Config->u8GetPresetListType())
    {
		NumberOfPresets = m_potun_Config->u8GetNoOfPresetsPerBank(midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1);
    }
	else
	{
		NumberOfPresets = m_potun_Config->u8GetNoOfPresetsPerBank(oGetADR3ToMidwTunerPresetListID((tun_tenAmFmTunerMsg)U16List));
	}
	return NumberOfPresets;
}