/************************************************************************
 * FILE:        clAars_ATPreparePresetStorage.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clAars_AtPiSearch method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/



#include "clAars_ATPreparePresetStorage.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATPreparePresetStorage.cpp.trc.h"
#endif

clAars_ATPreparePresetStorage::clAars_ATPreparePresetStorage(){

}



clAars_ATPreparePresetStorage::~clAars_ATPreparePresetStorage(){

}





clAars_ATPreparePresetStorage::clAars_ATPreparePresetStorage(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATPREPAREPRESETSTORAGE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){

}

void clAars_ATPreparePresetStorage::vSendATPreparePresetStorage(unsigned char u8Mode){
	ETG_TRACE_USR4(("clAars_ATPreparePresetStorage::vSendATPreparePresetStorage: %d", u8Mode ));
	clCMATPreparePresetStorageSet oData;
	oData.setMode((clCMEnum_Mode::enMode)u8Mode);
	vSet(oData);
}
