/************************************************************************
 * FILE:           clAars_ATSetPINew.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_ATSetPINew
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   06-Mar-2015
				
 *************************************************************************/


#if !defined(clAars_ATPI__INCLUDED_)
#define clAars_ATPI__INCLUDED_

#include "AarsApp/clClientProperty.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_ATPI : public tuner::AarsApp::clClientProperty
{

public:
    clAars_ATPI();
   virtual ~clAars_ATPI();

   /**
    *
    * @param poAarsHandler
    */
   clAars_ATPI(tuner::AarsApp::clAarsHandler* poAarsHandler);

   void vSelectPIFrequency(unsigned short u16PI, unsigned int u32Frequency);
   void vIncrementStep(unsigned char u8Nsteps);
   void vDecrementStep(unsigned char u8Nsteps);

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
   virtual void vError(tunerVector<unsigned char> bitStream);
private:



};







#endif /* clAars_ATPI__INCLUDED_ */
