/************************************************************************
 * FILE:           clAars_ATHDImageFileUpdate.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_ATHDImageFileUpdate
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  20-Jul-2015        vnd4kor
				
 *************************************************************************/


#if !defined(clAars_ATHDImageFileUpdate_h)
#define clAars_ATHDImageFileUpdate_h

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

class clConfigInterface;

#include "AarsApp/clClientProperty.h"

/**
 * @author vnd4kor
 * @version 1.0
 * @created 09-Mar-2015 10:20:45
 */
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_ATHDImageFileUpdate : public tuner::AarsApp::clClientProperty
{
private:
	clConfigInterface* m_poclConfigInterface;
	clCMEnum_HDImageType::enHDImageType vGetHDImageTypeConfiguration(tU8 u8HDImageType);

public:
   clAars_ATHDImageFileUpdate();
   virtual ~clAars_ATHDImageFileUpdate();

   /**
    *
    * @param poAarsHandler
    */
   clAars_ATHDImageFileUpdate(tuner::AarsApp::clAarsHandler* poAarsHandler,clConfigInterface* poclConfigInterface);

   void vSetHDImageFileUpdate(unsigned char u8HDAudioProgramBitMask,clCMEnum_HDImageType::enHDImageType u8HDImageType);
   
   virtual void vOnServiceAvailable();
 
protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);

};

#endif // !defined(clAars_ATHDImageFileUpdate_h)
