/************************************************************************
 * FILE:           clAars_ATHDImageFileUpdate.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATHDImageFileUpdate
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  10-Mar-2015        vnd4kor
				
 *************************************************************************/



#include "clAars_ATHDImageFileUpdate.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATHDImageFileUpdate.cpp.trc.h"
#endif

#define HDAUDIOPROGRAM_BITMASK 0xff

clAars_ATHDImageFileUpdate::clAars_ATHDImageFileUpdate(){
	m_poclConfigInterface = NULL;
}



clAars_ATHDImageFileUpdate::~clAars_ATHDImageFileUpdate(){
	m_poclConfigInterface = NULL;
}




clAars_ATHDImageFileUpdate::clAars_ATHDImageFileUpdate(tuner::AarsApp::clAarsHandler* poAarsHandler,clConfigInterface* poclConfigInterface):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATHD_IMAGEFILEUPDATE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
  ,m_poclConfigInterface(poclConfigInterface){

}

  
void clAars_ATHDImageFileUpdate::vSetHDImageFileUpdate(unsigned char u8HDAudioProgramBitMask,clCMEnum_HDImageType::enHDImageType e8HDImageType)
{
	ETG_TRACE_USR4(("clAars_ATHDImageFileUpdate::vSetHDImageFileUpdate: "
		"APBitMask = 0x%02x HDImgType = %d",u8HDAudioProgramBitMask,e8HDImageType));
	clCMATHDImageFileUpdateSet oData;
	oData.setHDAudioProgramBitMask(u8HDAudioProgramBitMask);
	oData.setHDImageType(e8HDImageType);
	vSet(oData);
}

void clAars_ATHDImageFileUpdate::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMATHDImageFileUpdateStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_ATHDImageFileUpdate::vStatus: "));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewATHDImageFileUpdateStatus(oData);
}

void clAars_ATHDImageFileUpdate::vOnServiceAvailable()
{
	if(m_poclConfigInterface != NULL)
	{
		if(m_poclConfigInterface->u32GetConfigData("HDSupported") && (m_poclConfigInterface->u32GetConfigData("HDImageType") != 0))
		{
			vSetHDImageFileUpdate(HDAUDIOPROGRAM_BITMASK, vGetHDImageTypeConfiguration((tU8)m_poclConfigInterface->u32GetConfigData("HDImageType")));
		}
		else
		{
			ETG_TRACE_USR4(("clAars_ATHDImageFileUpdate::vOnServiceAvailable() HDSupported = %d, HDImageType = %d",
					m_poclConfigInterface->u32GetConfigData("HDSupported"), m_poclConfigInterface->u32GetConfigData("HDImageType")));
		}
	}
}

clCMEnum_HDImageType::enHDImageType clAars_ATHDImageFileUpdate::vGetHDImageTypeConfiguration(tU8 u8HDImageType)
{
	clCMEnum_HDImageType oEnumHDImageType;
	if(u8HDImageType == 1)
	{
		oEnumHDImageType.enType = clCMEnum_HDImageType::Station_Logo_Or_Service_Logo;
	}
	else if(u8HDImageType == 2)
	{
		oEnumHDImageType.enType = clCMEnum_HDImageType::Primary_Image;
	}
	else
	{
		oEnumHDImageType.enType = clCMEnum_HDImageType::All_Image_Types;
	}
	return oEnumHDImageType.enType;
}
