/************************************************************************
 * FILE:           clAars_ATHDAudioProgramDirect.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATHDAudioProgramDirect
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  11-Jun-2015         vnd4kor
				
 *************************************************************************/





#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_ATHDAudioProgramDirect.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATHDAudioProgramDirect.cpp.trc.h"
#endif



clAars_ATHDAudioProgramDirect::~clAars_ATHDAudioProgramDirect(){

}

clAars_ATHDAudioProgramDirect::clAars_ATHDAudioProgramDirect(tuner::AarsApp::clAarsHandler* poAarsHandler): 
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATHD_AUDIOPROGRAMDIRECT, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{

}

void clAars_ATHDAudioProgramDirect::vSelectHDAudioProgramDirect(unsigned int u32Frequency, unsigned char u8AudioProgramNumber)
{
	ETG_TRACE_USR4(("clAars_ATHDAudioProgramDirect::vSelectHDAudioProgram: Frequency = %d , AudioProgram = %d ", u32Frequency,u8AudioProgramNumber ));
	clCMATHDAudioProgramDirectSet oData;
	oData.setHDAudioProgram((clCMEnum_ATHDAudioProgram::enATHDAudioProgram)u8AudioProgramNumber);
	oData.setFrequency(u32Frequency);
	vSet(oData);
}
 
void clAars_ATHDAudioProgramDirect::vStatus(tunerVector<unsigned char> &/*bitStream*/)
{

}