/************************************************************************
 * FILE:           clAars_ATFrequency.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATFrequency
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
				
 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_ATFrequency.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATFrequency.cpp.trc.h"
#endif

clAars_ATFrequency::clAars_ATFrequency()
{

}
clAars_ATFrequency::~clAars_ATFrequency()
{

}

clAars_ATFrequency::clAars_ATFrequency(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_ATFREQUENCY, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{

}

void clAars_ATFrequency::vStatus(tunerVector<unsigned char> & /*bitStream*/)
{
    ETG_TRACE_USR4(("clAars_ATFrequency::vStatus:"));
}

void clAars_ATFrequency::vSelectDirectFrequency(unsigned int u32Frequency)
{
    ETG_TRACE_USR4(("clAars_ATFrequency::vSelectDirectFrequency: %d" , u32Frequency));
    clATFrequencySetGet oData;
    oData.setFrequency(u32Frequency);
    vSetGet(oData);
}
void clAars_ATFrequency::vIncrementStep(unsigned char u8Nsteps)
{
    ETG_TRACE_USR4(("clAars_ATFrequency::vIncrementStep: %d" , u8Nsteps));
}
void clAars_ATFrequency::vDecrementStep(unsigned char u8Nsteps)
{
    ETG_TRACE_USR4(("clAars_ATFrequency::vDecrementStep: %d" , u8Nsteps));
}

void clAars_ATFrequency::vError(tunerVector<unsigned char> bitStream){
    ETG_TRACE_USR4(("clAars_ATFrequency::vError received"));
     clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_ATFrequency::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnATFrequencyError(oData);
}
