/************************************************************************
 * FILE:            clAars_AFBestSwitch.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_AFBestSwitch
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  Oct 9, 2015          pmn3kor
				
 *************************************************************************/



#include "Aars/clAars_AFBestSwitch.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "ADRMsg/ADRMsg_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "tun_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_AFBestSwitch.cpp.trc.h"
#endif

/*****************************************************************************

******************************************************************************/
clAars_AFBestSwitch::~clAars_AFBestSwitch() {

}
/*****************************************************************************

******************************************************************************/
clAars_AFBestSwitch::clAars_AFBestSwitch(tuner::AarsApp::clAarsHandler* poAarsHandler):
 tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_AFSWITCHFEATURES, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{

}
/*****************************************************************************

******************************************************************************/
void clAars_AFBestSwitch::vSetAFBestSwitch(unsigned char u8NewAFSwitch)
{
   ETG_TRACE_USR4(("vSetAFBestSwitch %d", u8NewAFSwitch ));
   clCMAfBestSwitchSetGet oData;
   oData.AfSwitches = u8NewAFSwitch;
   vSetGet(oData);
}

/*****************************************************************************

******************************************************************************/
void clAars_AFBestSwitch::vStatus(tunerVector<unsigned char> &/*bitStream*/)
{

}



