/************************************************************************
 * FILE:           clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
					   auj1kor	
 *************************************************************************/

#ifndef CLTMCTUNER_PROPERTY_G_SURVIELLANCE_LISTUPDATE_H_
#define CLTMCTUNER_PROPERTY_G_SURVIELLANCE_LISTUPDATE_H_

#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"

class clAars_CM_StationListConfig;
class clAars_CM_StationListRelease;
class tun_MsgToHMI;
class clConfigInterface;
class tun_HMIManager;

class clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE();
      clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE( tuner::CcaApp::clCCAhandler* poCCAhandler,tun_MsgToHMI* potun_MsgToHMI,
    		  clConfigInterface* poclConfigInterface, clAars_CM_StationListConfig* poclAars_CM_StationListConfig , clAars_CM_StationListRelease* poclAars_CM_StationListRelease,tun_HMIManager* potun_HMIManager);
	  virtual tVoid vOnCM_StationListStatus(clCMStationsListStatus &oData);
	  virtual tVoid vSendSDSStationListConfig();

   protected:
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vSet(amt_tclServiceData* poInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);
   private:

      tVoid vSendStatus();
	  tVoid vPopulateStationList(midw_fi_tcl_TunerConfigListElement &oTunerStationListElement,
			  tunerVector<clCMADRBaseType_StationsListData>::iterator ActualIt);
	  tVoid vTraceStationListElement(midw_fi_tcl_TunerConfigListElement &oTunerStationListElement);
	  tVoid vSendStationListRelease();
	  tU8	vGetConfigListIDFromFreq(unsigned int u32Frequency);
	  tun_MsgToHMI* m_potun_MsgToHMI;
      clAars_CM_StationListConfig* m_poclAars_CM_StationListConfig;
      clAars_CM_StationListRelease* m_poclAars_CM_StationListRelease;
      clConfigInterface* m_poclConfigInterface;
	  tun_HMIManager* m_potun_HMIManager;
};



#endif /* CLTMCTUNER_PROPERTY_G_SURVIELLANCE_LISTUPDATE_H_ */
