/************************************************************************
 * FILE:           clTmcTuner_Property_G_Mute_Request.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_LISTUPDATE_NOTIFICATION.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_Mute_Request.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_DRMTestMode.h"
#include "tuner_trace.h"

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MUTE_HANDLER
#include "trcGenProj/Header/clTmcTuner_Property_G_Mute_Request.cpp.trc.h"
#endif

using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_Mute_Request::~clTmcTuner_Property_G_Mute_Request()
{

}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_Mute_Request::clTmcTuner_Property_G_Mute_Request(clCCAhandler* poCCAhandler)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST, poCCAhandler)
{

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_Mute_Request::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   /*mhv6kor :Commented to make sure Demute is not by default during upreg */
   //midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus oMessage;
   //vStatus(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_Mute_Request::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_Mute_Request::vGet(amt_tclServiceData* /*poInMsg*/)
{

}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_Mute_Request::vSendMuteDemuteRequestStatus(bool bMuteState, bool bInterrupt)
{
	ETG_TRACE_USR4(( "clTmcTuner_Property_G_Mute_Request::vSendMuteDemuteRequestStatus()"));
	midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus oMessage;

	oMessage.bMute = bMuteState;
	oMessage.u8Attenuation = 0;
	oMessage.bMute_Interrupt = bInterrupt;

	vStatus(oMessage);
}
