/************************************************************************
 * FILE:           clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	24/08/2018	 | pmn3kor					  	  | Initial version of the file
 *************************************************************************/

#ifndef clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST_h
#define clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST_h

#include "CcaApp/clServerProperty.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"
/*----------------------------------------------------------------------*/

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
#include"diaglib_if.h"
#endif

#include "TunerApp/StationNameJapan/clJapanStationName.h"

class clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST: public  tuner::CcaApp::clServerProperty
{
public:
	clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST(tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName);
   ~clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST();

   void vSendStatusToClient();

protected:
      virtual void vGet(amt_tclServiceData* poInMsg);
      virtual void vUpreg(amt_tclServiceData* poInMsg);
      virtual void vSet(amt_tclServiceData* poInMsg);

private:
   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_STATION_NAME_LISTStatus m_oMessage;
   clJapanStationName *m_poclJapanStationName;
   void vPopulateJapanStationNameList();

};





#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_PROPERTY_G_JAPAN_STATION_NAME_LIST_H_ */
