/************************************************************************
 * FILE:           clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	24/08/2018	 | pmn3kor					  	  | Initial version of the file
 *************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#include "clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.h"
#include "TunerApp/StationNameJapan/clJapanStationName.h"
#include "tun_defines.h"
#include "datatypes/tVector.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST.cpp.trc.h"
#endif

using namespace tuner::CcaApp;

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST(clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName)
: clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_JAPAN_STATION_NAME_LIST, poCCAhandler),
  m_poclJapanStationName(poclJapanStationName)
{
}

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::~clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST()
{
	m_poclJapanStationName = NULL;
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::vSet(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::vGet(amt_tclServiceData* /*poInMsg*/)
{
//get not supported for this FI
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   //send property status when clients register for this property
   vSendStatusToClient();
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::vSendStatusToClient()
{
	if(m_poclJapanStationName == NULL)
	{
		NORMAL_M_ASSERT(m_poclJapanStationName!=NULL);
		return;
	}
	m_oMessage.u8JapanStationCount = m_poclJapanStationName->u8GetStationCount();
	if(m_oMessage.u8JapanStationCount > 0)
	{
		vPopulateJapanStationNameList();
	}
	else
	{
		m_oMessage.u16SelectedElement = 0;
		//list should be empty without any elements
	}
	ETG_TRACE_USR4(( " vSendStatusToClient :  u8JapanStationCount=%d u16SelectedElement=%d",  m_oMessage.u8JapanStationCount, m_oMessage.u16SelectedElement));
	vStatus(m_oMessage);

}


/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST::vPopulateJapanStationNameList()
{
	tunerVector<TunerJapanStationName> oJpnStnNameList;
	m_oMessage.u16SelectedElement = m_poclJapanStationName->u16GetJpnStnNameListData(oJpnStnNameList);
	for(tunerVector<TunerJapanStationName>::iterator it = oJpnStnNameList.begin(); it!= oJpnStnNameList.end(); ++it)
	{
		midw_fi_tcl_TunerJapanStationName oJpnStnName;
		oJpnStnName.u16IndexID = it->u16IndexID;
		oJpnStnName.sJapanStationName.bSet(it->sJpnStnName.c_str() ,midw_fi_tclString::FI_EN_UTF8);
		m_oMessage.JapanStationNamesList.TunerJapanStationName.push_back(oJpnStnName);

		ETG_TRACE_USR4(("vPopulateJapanStationNameList : u16IndexID = %d, sJapanStationName = %s",
				oJpnStnName.u16IndexID, oJpnStnName.sJapanStationName.szGet(midw_fi_tclString::FI_EN_UTF8)));
	}
}
