/************************************************************************
 * FILE:           clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.h"
#include "CcaApp/clCCAhandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "Aars/clAars_ATHDImageFileUpdate.h"
#include "kdsconfig/clConfigInterface.h"
#include "tun_MsgToHMI.h"

#define ERROR_NOTAVAILABLE 0x000B

using namespace tuner::CcaApp;


#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.cpp.trc.h"
#endif

#define INVALID_AUDIOPROGRAM 255
#define INVALID_LOTID 0x0000
#define INVALID_STATIONID 0x00000000
#define PRIMARYIMAGE	0xbe4b7536
/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::~clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE()
{
	m_poATHDImageFileUpdate = NULL;
	m_potun_MsgToHMI = NULL;
	m_poclHDStationLogoManagement = NULL;
	m_u32ActiveHDStationID = 0;
	m_u16ActiveAudioProgramLOTID = 0;
	m_u8ActiveAudioProgram = 0xff;
	m_poclConfigInterface = 0;
	m_potun_MsgFromHMI = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
#ifdef VARIANT_P_RECEPTION_FC_TMCTUNER_UTEST
clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE(clCCAhandler* poCCAhandler)
       :clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_IMAGEFILE_UPDATE, poCCAhandler)
{
       m_u32ActiveHDStationID = 0;
       m_u16ActiveAudioProgramLOTID = 0;
       m_u8ActiveAudioProgram = 0xff;
}
#endif

clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE(clCCAhandler* poCCAhandler,clAars_ATHDImageFileUpdate* poATHDImageFileUpdate,
		tun_MsgToHMI* potun_MsgToHMI, clHDStationLogoManagement* poclHDStationLogoManagement, clConfigInterface* poclConfigInterface, tun_MsgFromHMI* potun_MsgFromHMI)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_IMAGEFILE_UPDATE, poCCAhandler),m_poATHDImageFileUpdate(poATHDImageFileUpdate),
   m_u8ActiveAudioProgram(INVALID_AUDIOPROGRAM),m_u16ActiveAudioProgramLOTID(INVALID_LOTID),
   m_potun_MsgToHMI(potun_MsgToHMI), m_poclHDStationLogoManagement(poclHDStationLogoManagement), m_poclConfigInterface(poclConfigInterface),
   m_potun_MsgFromHMI(potun_MsgFromHMI)
{
	m_u32ActiveHDStationID = 0;
	m_u16ActiveAudioProgramLOTID = 0;
	m_u8ActiveAudioProgram = 0xff;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vGet(amt_tclServiceData* /*poInMsg*/)
{
	if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
	{
		vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_IMAGEFILE_UPDATE,ERROR_NOTAVAILABLE);
	}
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
	{
		vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_IMAGEFILE_UPDATE,ERROR_NOTAVAILABLE);
	}
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vSendStatus(tBool bDisplayImage, clCMATHDImageFileUpdateStatus& oImageFileData)
{
	midw_tunerfi_tclMsgFID_TUN_G_HD_IMAGEFILE_UPDATEStatus oMessage;
	oMessage.bDisplayImage = bDisplayImage;
	oMessage.ImageFileInfo.u32HDStationId = oImageFileData.getHDStationId();
	tU8 u8HDImageType = (tU8)oImageFileData.getHDImageType();
	oMessage.ImageFileInfo.e8HDImageType.enType = (midw_fi_tcl_e8_Tun_HDImageType::tenType)u8HDImageType;
	oMessage.ImageFileInfo.e8HDImageCoding.enType = (midw_fi_tcl_e8_Tun_HDImageCoding::tenType)oImageFileData.getHDImageCoding();
	oMessage.ImageFileInfo.e8HDAudioProgram.enType = (midw_fi_tcl_e8_Tun_HDAudioProgram::tenType)oImageFileData.getHDAudioService();
	oMessage.ImageFileInfo.u32NoOfImageFileBytes = oImageFileData.getNumberOfImageFileBytes();
	if(0 < oMessage.ImageFileInfo.u32NoOfImageFileBytes)
	{
		oMessage.ImageFileInfo.ImageFileBytes = oImageFileData.getImageFileBytes();
	}
	vStatus(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewATHDImageFileUpdateStatus(clCMATHDImageFileUpdateStatus& oImageFileData)
{
	vPrintImageData(oImageFileData);

	if(oImageFileData.getHDImageType() == clCMEnum_HDImageType::Station_Logo_Or_Service_Logo)
	{
		ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE:vOnNewATHDImageFileUpdateStatus() station logo received"));
		if(m_poclHDStationLogoManagement == NULL || m_potun_MsgFromHMI == NULL)
		{
			return;
		}
		if(m_poclHDStationLogoManagement->vOnNewStationLogo(oImageFileData, oImageFileData.getHDStationId()))
		{
			m_potun_MsgFromHMI->vSendStationInfoStatusMessage();
		}
	}

	else if(oImageFileData.getHDImageType() == clCMEnum_HDImageType::Primary_Image)
	{
		ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE:vOnNewATHDImageFileUpdateStatus() primary image file saved"));
		oHDImageMemoryManagement.vAddImageToMap(oImageFileData);

		if(bIsImageDataSameAsCurrentXHDRData(oImageFileData))
		{
			vSendImageUpdateToClient(oImageFileData);
		}
		ETG_TRACE_USR1(("CCR.ENDING.HD_RADIO_PRIMARY_IMAGE:vOnNewATHDImageFileUpdateStatus"));
	}
}

/**************************************************************************//**
*
******************************************************************************/
tBool clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::bIsEqualImage(clCMATHDImageFileUpdateStatus& oData,\
	unsigned char u8ActiveAudioProgram, unsigned short u16ActiveLOTID, unsigned int u32ActiveStationID)
{
	bool bEqualImage = false;
	if((oData.getHDAudioService() == u8ActiveAudioProgram)
		&& (oData.getLOTID() == u16ActiveLOTID)
		&& (oData.getHDStationId() == u32ActiveStationID)
		)
	{
		ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::bIsEqualImage: True" ));
		bEqualImage = true;
	}
	else
	{
		ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::bIsEqualImage: False\n"
			"=>	oData.HDAudioService        : %d        u8ActiveAudioProgram         : %d\n"
			"=>	oData.LOTID                 : 0x%04x    u16ActiveLOTID               : 0x%04x\n"
			"=>	oData.HDStationId			: 0x%08x    u32ActiveStationID			 : 0x%08x\n"
		,oData.getHDAudioService(),u8ActiveAudioProgram,oData.getLOTID()
		,u16ActiveLOTID,oData.getHDStationId(),u32ActiveStationID
		));
	}
	return bEqualImage;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vSendImageUpdateToClient(clCMATHDImageFileUpdateStatus& oImageFileData)
{
	m_ATHDImageFileLastSent = oImageFileData;
	vSendStatus(true,oImageFileData);
}

/**************************************************************************//**
*
******************************************************************************/
tBool clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::bIsImageDataSameAsLastSentImage(clCMATHDImageFileUpdateStatus& oImageFileData)
{
	return bIsEqualImage(oImageFileData,m_ATHDImageFileLastSent.getHDAudioService(),m_ATHDImageFileLastSent.getLOTID(),m_ATHDImageFileLastSent.getHDStationId());
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewPSDXHDRImageDisplayTrigger(\
	unsigned char u8ActiveAudioProgram, unsigned short u16ActiveLOTID, unsigned long u32HDStationID)
{
	m_u8ActiveAudioProgram = u8ActiveAudioProgram;
	m_u16ActiveAudioProgramLOTID = u16ActiveLOTID;
	m_u32ActiveHDStationID = (unsigned int)u32HDStationID;

	if(oHDImageMemoryManagement.bIsImageExist(m_u32ActiveHDStationID, m_u8ActiveAudioProgram, m_u16ActiveAudioProgramLOTID) == true)
	{
		ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewPSDXHDRImageDisplayTrigger sent image to HMI" ));
		clCMATHDImageFileUpdateStatus oData = oHDImageMemoryManagement.objGetImageFromMap(m_u32ActiveHDStationID, m_u8ActiveAudioProgram, m_u16ActiveAudioProgramLOTID);
		vSendImageUpdateToClient(oData);
	}
}

/**************************************************************************//**
*
******************************************************************************/
tBool clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::bIsImageDataSameAsCurrentXHDRData(clCMATHDImageFileUpdateStatus& oImageFileData)
{
	return bIsEqualImage(oImageFileData,m_u8ActiveAudioProgram,m_u16ActiveAudioProgramLOTID,m_u32ActiveHDStationID);
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vClearData()
{
	ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vClearData " ));

	m_u8ActiveAudioProgram = INVALID_AUDIOPROGRAM;
	m_u16ActiveAudioProgramLOTID = INVALID_LOTID;
	m_u32ActiveHDStationID = INVALID_STATIONID;

	clCMATHDImageFileUpdateStatus ATHDImageFileLastSent;
	m_ATHDImageFileLastSent = ATHDImageFileLastSent;

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vPrintImageData(clCMATHDImageFileUpdateStatus& oImageFileData)
{
	ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewATHDImageFileUpdateStatus: "
		"\n=>	StationId               :	0x%08x"
		"\n=>	HDImageType             :	%d"
		"\n=>	HDImageCoding           :	%d"
		"\n=>	HDAudioProgram          :	%d"
		"\n=>	HDApplicationMIMEType   :   0x%08x"
		"\n=>	LOT ID                  :   0x%04x"
		"\n=>	NumberOfBytes           :	%d"
		,oImageFileData.getHDStationId()
		,oImageFileData.getHDImageType()
		,oImageFileData.getHDImageCoding()
		,oImageFileData.getHDAudioService()
		,oImageFileData.getHDApplicationMimeType()
		,oImageFileData.getLOTID()
		,oImageFileData.getNumberOfImageFileBytes()
		));
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewPSDXHDRBlankImageDisplayTrigger(\
	unsigned char /*u8ActiveAudioProgram*/, unsigned long /*u32HDStationID*/, unsigned short /*u16ActiveLotID*/)
{
	ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewPSDXHDRBlankImageDisplayTrigger:" ));

	if(oHDImageMemoryManagement.bIsImageExist(m_u32ActiveHDStationID, m_u8ActiveAudioProgram, m_u16ActiveAudioProgramLOTID) == true)
	{
		vSendBlankImageDisplayToClient();
	}
}

/****
 *
 */
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vSendBlankImageDisplayToClient()
{
	ETG_TRACE_USR4((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vSendBlankImageDisplayToClient" ));
	clCMATHDImageFileUpdateStatus oData; //empty data
	vSendStatus(false,oData);
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewPSDXHDRFlushImageTrigger(\
	unsigned char u8ActiveAudioProgram, unsigned int u32ActiveStationID, unsigned int u32ActiveAudioProgramMIMEHash)
{
	ETG_TRACE_USR2((" clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::vOnNewPSDXHDRFlushImageTrigger MIMEHASH = %d", u32ActiveAudioProgramMIMEHash));
	if(u32ActiveAudioProgramMIMEHash == PRIMARYIMAGE)
	{
		oHDImageMemoryManagement.vFlushImagesFromMap(u32ActiveStationID, u8ActiveAudioProgram);
	}
}
/**
 *
 */
midw_fi_tclString clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE::strGetActiveStationLogoPath(unsigned int u32HDStationId, unsigned char u8ActiveAudioProgram)
{
	std::string strStationLogoPath = m_poclHDStationLogoManagement->strGetActiveStationLogoPath(u32HDStationId, u8ActiveAudioProgram);
	if(strStationLogoPath.empty())
	{
		return NULL;
	}
	else
	{
		return (midw_fi_tclString)strStationLogoPath.c_str();
	}
}
