/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_STATIC_LIST.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_GET_STATIC_LIST.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/


#ifndef clTmcTuner_Property_G_GET_ACTIVE_PRESETLIST_h
#define clTmcTuner_Property_G_GET_ACTIVE_PRESETLIST_h


#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
class clTmcTuner_Method_S_DISABLE_BAND;
class tun_Config;
class tun_MsgToHMI;
class clAars_ATPresetList_XX;
class tun_HMIManager;
class clConfigInterface;
struct stMixedPresetListCopyForDisableBand
{
	tU8 u8PresetEleNo;
	tU32 u32Frequency;
};
class clTmcTuner_Property_G_GET_STATIC_LIST : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_G_GET_STATIC_LIST();
      clTmcTuner_Property_G_GET_STATIC_LIST( tuner::CcaApp::clCCAhandler* poCCAhandler,tun_MsgToHMI* potun_MsgToHMI, tun_Config* potun_Config,tun_HMIManager* potun_HMIManager,clAars_ATPresetList_XX* poclAars_ATPresetList_XX,clConfigInterface* poclConfigInterface);
	  virtual tVoid vOnCMATPresetList_XX_Status(clCMATPresetList_XX &oData,short u16FunctionId);
	  tVoid vSetclTmcTuner_Method_S_DISABLE_BANDPtr(clTmcTuner_Method_S_DISABLE_BAND* poclTmcTuner_Method_S_DISABLE_BAND);
	  void vDisableBand_DeletePresetElement(midw_fi_tcl_e8_Tun_TunerBand::tenType enBand);
	  tVoid vGetPresetList();
   protected:
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vSet(amt_tclServiceData* poInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);
   private:
      tVoid vSendStatus();
	  tun_MsgToHMI* m_potun_MsgToHMI;
	  tun_Config* m_potun_Config;
	  clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
	  clConfigInterface*      m_poclConfigInterface;
	  tVoid vPopulatePresetList(midw_fi_tcl_TunerStaticListElement &oTunerStaticListElement,clCMATPresetList_XX &oData,
			  unsigned char u8Index);
	  tVoid vPackPSNameOrHDCallSign_DRMServiceLabel(midw_fi_tcl_TunerStaticListElement &oTunerStaticListElement,clCMATPresetList_XX &oData,unsigned char u8Index);
	  tVoid vTracePresetListElement(midw_fi_tcl_TunerStaticListElement &oTunerStaticListElement);
	  clTmcTuner_Method_S_DISABLE_BAND* m_poclTmcTuner_Method_S_DISABLE_BAND;
	  tBool bIsDeletedPresetsElementsSuccess(clCMATPresetList_XX &oData,short u16FunctionId);
	  tunerVector <stMixedPresetListCopyForDisableBand> m_stMixedPresetListCopyForDisableBand;
	  tun_HMIManager* m_potun_HMIManager;
	  tBool blCheckIsMixedPreseteElemDeleted(clCMATPresetList_XX &oData,short u16FunctionId);
	  tBool blCheckIsAllPresetElementsDeleted(clCMATPresetList_XX &oData,short u16FunctionId);

};

#endif
