/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/

#ifndef clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS_h
#define clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS_h


#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "tun_HMIManager.h"


class clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS();
      clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS( tuner::CcaApp::clCCAhandler* poCCAhandler, tun_HMIManager* potun_HMIManager);
      virtual tVoid vOnEnhancedTestModeStatus(unsigned char u8PhysicalTuner, clCMEnhancedTestModeStatus &oData);

   protected:
      virtual tVoid vSet(amt_tclServiceData* poInMsg);
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);

   private:
      tun_HMIManager* m_potun_HMIManager;
      midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus m_oMessage;
      tVoid vPrintTraces(midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus &oTestModeDataStatusMsg);
};

#endif
