/************************************************************************
 * FILE:            clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of   clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.h"
#include "CcaApp/clCCAhandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tun_FI_HelpFunc.h"

using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::~clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS()
{
    m_potun_HMIManager = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS(clCCAhandler* poCCAhandler, tun_HMIManager* potun_HMIManager)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DATA_TESTMODE_DDADDS, poCCAhandler)
{
    m_potun_HMIManager = potun_HMIManager;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vSet(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vGet(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vOnEnhancedTestModeStatus(unsigned char u8PhysicalTuner, clCMEnhancedTestModeStatus &oEnhancedTestModeStatusData)
{
    midw_fi_tclString sUtf8String ;
    /* Tuner Header */
    tun_FI_HelpFunc :: bConverttU8toEnumPhsicalTuner(u8PhysicalTuner ,m_oMessage.TunerTestModeData.u8PhysicalTuner.enType);

    /* Modulation */
    tU8 u8Source = (tU8)oEnhancedTestModeStatusData.getModulation();
    m_oMessage.TunerTestModeData.u8Source.enType = (midw_fi_tcl_e8_Tun_Testmode_TunerBand::tenType)u8Source;

    /* Frequency */
    m_oMessage.TunerTestModeData.u32AFFrequency = oEnhancedTestModeStatusData.getFrequency();

    /* Current PI */
    m_oMessage.TunerTestModeData.u16CurrentPI = oEnhancedTestModeStatusData.getCurrentPI();

    /*Target PI */
    m_oMessage.TunerTestModeData.u16TargetPI = oEnhancedTestModeStatusData.getTargetPI();

    /* Quality */
    m_oMessage.TunerTestModeData.u8Quality = oEnhancedTestModeStatusData.getQuality();

    /* FieldStrength */
    m_oMessage.TunerTestModeData.u8Fieldstrength = oEnhancedTestModeStatusData.getFieldstrength();

    /* Multipath */
    m_oMessage.TunerTestModeData.u8Multipath = oEnhancedTestModeStatusData.getMultipath();

    /* Neighbour */
    m_oMessage.TunerTestModeData.u8Neighbour = oEnhancedTestModeStatusData.getNeighbourChannelDistortion();

    /* AFListLength */
    m_oMessage.TunerTestModeData.u8AFListLength = oEnhancedTestModeStatusData.getAFListLength();
    /* Highcut */
    m_oMessage.TunerTestModeData.u8HiCut = oEnhancedTestModeStatusData.getHicut();

    /* Sharx */
    m_oMessage.TunerTestModeData.u8Sharx = oEnhancedTestModeStatusData.getSharx();

    /* Current Station Name*/
    m_potun_HMIManager->vConvertRDSPSNametotString((const tU8*)oEnhancedTestModeStatusData.getCurrentStationname().c_str(), &sUtf8String) ;
    m_oMessage.TunerTestModeData.sCurrentStationName.bSet( sUtf8String, midw_fi_tclString::FI_EN_UTF8);
    /* Fix Station Name*/
    m_potun_HMIManager->vConvertRDSPSNametotString((const tU8*)oEnhancedTestModeStatusData.getFixStationname().c_str(), &sUtf8String) ;
    m_oMessage.TunerTestModeData.sFixPSName.bSet( sUtf8String, midw_fi_tclString::FI_EN_UTF8);

    /*ScrollPSStatus*/
    m_oMessage.TunerTestModeData.bScrollPSStatus = oEnhancedTestModeStatusData.getScrollPsStatus();

    /*AFStatus*/
    m_oMessage.TunerTestModeData.bAFStatus = oEnhancedTestModeStatusData.getAfStatus();

    /*FM deviation*/
    m_oMessage.TunerTestModeData.u8FMDeviation = oEnhancedTestModeStatusData.getFmDeviation();
    /*RDS deviation*/
    m_oMessage.TunerTestModeData.u8RDSDeviation = oEnhancedTestModeStatusData.getRdsDeviation();

    /*IF Offset*/
    m_oMessage.TunerTestModeData.s8IFOffset = oEnhancedTestModeStatusData.getIfOffset();

    /*RDS Offset*/
    m_oMessage.TunerTestModeData.s8RDSOffset = oEnhancedTestModeStatusData.getRdsOffset();

    /*Co Channel Status*/
    m_oMessage.TunerTestModeData.u8CoChannelStatus = oEnhancedTestModeStatusData.getCoChannelStatus();

    /*AGC*/
    m_oMessage.TunerTestModeData.u8AGC = oEnhancedTestModeStatusData.getAGC();
    /* ChannelSeperation */
    m_oMessage.TunerTestModeData.u8ChannelSeparation = oEnhancedTestModeStatusData.getChannelSeparation();

    /* RDS error rate */
    m_oMessage.TunerTestModeData.u8RdsErrorRate = oEnhancedTestModeStatusData.getRdsErrorRate();

    /* DiversityState */
    tU8 u8DiversityState = (tU8)oEnhancedTestModeStatusData.getDiversityState();
    m_oMessage.TunerTestModeData.e8DiversityState.enType = (midw_fi_tcl_e8_Tun_DiversityState::tenType)u8DiversityState;

    /* AntennaPathSwitch1 */
    tU8 u8AntennaPathSwitch1 = (tU8)oEnhancedTestModeStatusData.getAntennaPathSwitch1();
    m_oMessage.TunerTestModeData.e8AntennaPathSwitch1.enType = (midw_fi_tcl_e8_Tun_AntennaPathSwitch1::tenType)u8AntennaPathSwitch1;

    /* AntennaPathSwitch2 */
    tU8 u8AntennaPathSwitch2 = (tU8)oEnhancedTestModeStatusData.getAntennaPathSwitch2();
    m_oMessage.TunerTestModeData.e8AntennaPathSwitch2.enType = (midw_fi_tcl_e8_Tun_AntennaPathSwitch2::tenType)u8AntennaPathSwitch2;
    /* Info bits */
    m_oMessage.TunerTestModeData.u8TestmodeBits.u8Value = oEnhancedTestModeStatusData.getInfoBits();
    /* HicutExtender */
    m_oMessage.TunerTestModeData.u8HicutExtender = oEnhancedTestModeStatusData.getHicutExtender();

    vPrintTraces(m_oMessage);
    vStatus(m_oMessage);
    ETG_TRACE_USR1(("CCR.ENDING.TESTMODE_DATA:vOnEnhancedTestModeStatus"));
}

tVoid clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vPrintTraces(midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus &oTestModeDataStatusMsg)
{
    ETG_TRACE_USR2(( " clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vOnEnhancedTestModeStatus() \
                    Source = 0x%02x, Freq = %u, Current PI = 0x%x, Target PI = 0x%x " , \
                    oTestModeDataStatusMsg.TunerTestModeData.u8Source.enType,\
                    oTestModeDataStatusMsg.TunerTestModeData.u32AFFrequency,\
                    oTestModeDataStatusMsg.TunerTestModeData.u16CurrentPI,\
                    oTestModeDataStatusMsg.TunerTestModeData.u16TargetPI\
                    ));

    ETG_TRACE_USR2(( " clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vOnEnhancedTestModeStatus() \
                   Quality = 0x%02x, Fieldstrength = %d, Multipath = 0x%02x, NC = 0x%02x, AFListLength = 0x%02x" , \
                   oTestModeDataStatusMsg.TunerTestModeData.u8Quality,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8Fieldstrength,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8Multipath,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8Neighbour,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8AFListLength
                   ));

    ETG_TRACE_USR2((" clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vOnEnhancedTestModeStatus() CurrentStationname = %8s, FixStationname = %8s"\
                  ,(tChar*)oTestModeDataStatusMsg.TunerTestModeData.sCurrentStationName
                  ,(tChar*)oTestModeDataStatusMsg.TunerTestModeData.sFixPSName
                  ));


    ETG_TRACE_USR2(( " clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vOnEnhancedTestModeStatus()\
                   HiCut = 0x%02x, Sharx = 0x%02x, ScrollPSStatus = 0x%02x, AFStatus = 0x%02x, FMDeviation = 0x%02x" ,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8HiCut,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8Sharx,\
                   oTestModeDataStatusMsg.TunerTestModeData.bScrollPSStatus,\
                   oTestModeDataStatusMsg.TunerTestModeData.bAFStatus,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8FMDeviation
                   ));

    ETG_TRACE_USR2(( " tun_MsgToHMI::vOnEnhancedTestModeStatus() \
                 RDSDeviation = 0x%02x, IFOffset = 0x%02x, RDSOffset = 0x%02x, \
                 CoChannelStatus = 0x%02x, AGC = 0x%02x" ,\
                 oTestModeDataStatusMsg.TunerTestModeData.u8RDSDeviation,\
                 oTestModeDataStatusMsg.TunerTestModeData.s8IFOffset,\
                 oTestModeDataStatusMsg.TunerTestModeData.s8RDSOffset,\
                 oTestModeDataStatusMsg.TunerTestModeData.u8CoChannelStatus,\
                 oTestModeDataStatusMsg.TunerTestModeData.u8AGC\
                 ));

    ETG_TRACE_USR2(( " clTmcTuner_Property_G_GET_DATA_TESTMODE_DDADDS::vOnEnhancedTestModeStatus() \
                   CS = 0x%02x, RDSErrorRate = 0x%02x, Diversity State = 0x%02x, AntennaPathSwitch1 = 0x%02x, AntennaPathSwitch2 = 0x%02x, InfoBits = 0x%02x, HicutExtender = 0x%02x" ,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8ChannelSeparation,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8RdsErrorRate,\
                   oTestModeDataStatusMsg.TunerTestModeData.e8DiversityState.enType,\
                   oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch1.enType,\
                   oTestModeDataStatusMsg.TunerTestModeData.e8AntennaPathSwitch2.enType,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8TestmodeBits.u8Value,\
                   oTestModeDataStatusMsg.TunerTestModeData.u8HicutExtender\
                   ));
}
