/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_DARC_DATA.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_GET_DARC_DATA.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Property_G_GET_DARC_DATA.h"
#include "AMFMTuner/clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_DARCGetData.h"

using namespace tuner::CcaApp;

#include "tuner_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_G_GET_DARC_DATA.cpp.trc.h"
#endif

clTmcTuner_Property_G_GET_DARC_DATA* clTmcTuner_Property_G_GET_DARC_DATA::_theServer = NULL;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_GET_DARC_DATA::~clTmcTuner_Property_G_GET_DARC_DATA()
{
	m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = NULL;

	if( m_hTimerDARCAvail != OSAL_C_INVALID_HANDLE)
	{
	if(OSAL_OK != OSAL_s32TimerDelete( m_hTimerDARCAvail))
	{
	   NORMAL_M_ASSERT_ALWAYS ();
	}

	m_hTimerDARCAvail = OSAL_C_INVALID_HANDLE;
	}

}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_GET_DARC_DATA::clTmcTuner_Property_G_GET_DARC_DATA(clCCAhandler* poCCAhandler)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_DARC_DATA, poCCAhandler)
{
	m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = NULL;
	m_hTimerDARCAvail = OSAL_C_INVALID_HANDLE;

	/* create ADR supervision timer */
	tS32 s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vDARCAvailTimerCallback,
										   ( tPVoid )this, &m_hTimerDARCAvail );
	TUN_ASSERT_RETURN( s32OsalError == OSAL_OK);
}


void clTmcTuner_Property_G_GET_DARC_DATA::vSet_G_GET_DARC_DATA_Ptr(clTmcTuner_Property_G_GET_DARC_DATA* poclTmcTuner_Property_G_GET_DARC_DATA)
{
	if(poclTmcTuner_Property_G_GET_DARC_DATA != NULL)
	{
			_theServer = poclTmcTuner_Property_G_GET_DARC_DATA;
	}
}

void clTmcTuner_Property_G_GET_DARC_DATA::vSet_S_DARC_VICS_FREQUENCY_LIST(clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST* poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST)
{
	if(poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST != NULL)
	{
			m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST = poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST;
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_GET_DARC_DATA::vGet(amt_tclServiceData* /*poInMsg*/)
{

}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_GET_DARC_DATA::vSet(amt_tclServiceData* /*poInMsg*/)
{

}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_GET_DARC_DATA::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_GET_DARC_DATA::vOnCM_DARCDataStatus(clCMDARCGetDataStatus &oDARCDataStatus)
{
	if(m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Property_G_GET_DARC_DATA: vOnCM_DARCDataStatus , null pointer"));
		return;
	}
	ETG_TRACE_USR4(("clTmcTuner_Property_G_GET_DARC_DATA: vOnCM_DARCDataStatus"));
	midw_tunerfi_tclMsgFID_TUN_G_GET_DARC_DATAStatus oMessage;
	tunerVector<unsigned char> vActualData = oDARCDataStatus.getData();
	int u8Size = (int)vActualData.size();
	ETG_TRACE_USR4(("clTmcTuner_Property_G_GET_DARC_DATA: vOnCM_DARCDataStatus, size : %d",u8Size));
	oMessage.Frequency = m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST->u32GetRequstedDARCDataFreq();

	for(int u8DARCDataBlockIndex = TUN_DARCDATA_STARTBYTE ; u8DARCDataBlockIndex < u8Size ; u8DARCDataBlockIndex += TUN_DARC_DATA_BLOCKSIZE)
	{
		midw_fi_tcl_DARCDataBlock oDARCDataBlock;
		oDARCDataBlock.STAT_Status_Register.u8Value = vActualData.at(u8DARCDataBlockIndex);
		oDARCDataBlock.Block_Number_Register = 	vActualData.at(u8DARCDataBlockIndex+1);
		for(int u8DARCDataIndex = 0 ; u8DARCDataIndex < TUN_DARC_READDATA_SIZE ; u8DARCDataIndex++)
		{
			oDARCDataBlock.DARCDataList.push_back(vActualData.at(u8DARCDataBlockIndex+u8DARCDataIndex+2));
		}
		oMessage.DARCData.DARCDataBlock.push_back(oDARCDataBlock);
	}

	vStatus(oMessage);
	vStopDARCTimer();
	vStartDARCTimer();
}

tVoid clTmcTuner_Property_G_GET_DARC_DATA::vDARCAvailTimerCallback( tVoid* pArg)
{
	(tVoid)pArg;    /* unused parameter */
    ETG_TRACE_USR4(("clTmcTuner_Property_G_GET_DARC_DATA: vDARCAvailTimerCallback"));
	_theServer->m_poclTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST->vRequestDARCData();
}


tVoid clTmcTuner_Property_G_GET_DARC_DATA::vStartDARCTimer()
{
	ETG_TRACE_USR4(("clTmcTuner_Property_G_GET_DARC_DATA: vStartDARCTimer"));

	tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerDARCAvail, (tU32) TUN_DARC_TIMEOUT_MS, 0 );
	TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
}


tVoid clTmcTuner_Property_G_GET_DARC_DATA::vStopDARCTimer()
{
    ETG_TRACE_USR4(("clTmcTuner_Property_G_GET_DARC_DATA: vStopDARCTimer"));

    tS32 s32RetVal = OSAL_s32TimerSetTime( m_hTimerDARCAvail, 0, 0 );
    TUN_ASSERT_RETURN( s32RetVal == OSAL_OK);
}

