/************************************************************************
 * FILE:           clTmcTuner_Property_G_GET_CONFIG_LIST.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_GET_CONFIG_LIST.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#ifndef clTmcTuner_Property_G_GET_CONFIG_LIST_h
#define clTmcTuner_Property_G_GET_CONFIG_LIST_h


#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
class tun_ActualData;
class clAars_CM_StationListConfig;
class tun_MsgToHMI;
class tun_HMIManager;
class clConfigInterface;
class clTmcTuner_Property_G_GET_CONFIG_LIST : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_G_GET_CONFIG_LIST();
      clTmcTuner_Property_G_GET_CONFIG_LIST( tuner::CcaApp::clCCAhandler* poCCAhandler,tun_ActualData* potun_ActualData,clAars_CM_StationListConfig* poclAars_CM_StationListConfig,tun_MsgToHMI* potun_MsgToHMI,clConfigInterface* poclConfigInterface,tun_HMIManager* potun_HMIManager);
	  virtual tVoid vOnCM_StationListStatus(clCMStationsListStatus &oData);

   protected:
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vSet(amt_tclServiceData* poInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);
   private:
      tVoid vSendStatus();
	  tVoid vPopulateStationList(midw_fi_tcl_TunerConfigListElement &oTunerStationListElement,
			  tunerVector<clCMADRBaseType_StationsListData>::iterator ActualIt);
	  tun_ActualData* m_potun_ActualData;
	  clAars_CM_StationListConfig* m_poclAars_CM_StationListConfig;
	  tVoid vTraceStationListElement(midw_fi_tcl_TunerConfigListElement &oTunerStationListElement);
	  tU8 u8GetListIDfromFreq(tU32 u32Frequency);
	  tun_MsgToHMI* m_potun_MsgToHMI;
	  clConfigInterface*      m_poclConfigInterface;
	  tun_HMIManager* m_potun_HMIManager;
};

#endif
